/*
 * Decompiled with CFR 0.152.
 */
package jp.terasoluna.fw.util;

import java.io.File;
import jp.terasoluna.fw.util.HashUtil;
import jp.terasoluna.fw.util.PropertyUtil;
import jp.terasoluna.fw.util.StringUtil;

public class FileUtil {
    private static final String SESSION_DIR_BASE_KEY = "session.dir.base";

    public static String getSessionDirectoryName(String sessionId) {
        byte[] hash = HashUtil.hashSHA1(sessionId);
        return StringUtil.toHexString(hash, "");
    }

    public static File getSessionDirectory(String sessionId) {
        String dirBase = PropertyUtil.getProperty(SESSION_DIR_BASE_KEY);
        if (dirBase == null || "".equals(dirBase)) {
            dirBase = File.separator + "temp";
        }
        String dirName = FileUtil.getSessionDirectoryName(sessionId);
        return new File(dirBase + File.separator + dirName);
    }

    public static boolean makeSessionDirectory(String sessionId) {
        if (sessionId == null || "".equals(sessionId)) {
            return false;
        }
        return FileUtil.getSessionDirectory(sessionId).mkdirs();
    }

    public static boolean removeSessionDirectory(String sessionId) {
        return FileUtil.rmdirs(FileUtil.getSessionDirectory(sessionId));
    }

    public static boolean rmdirs(File dir) {
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    FileUtil.rmdirs(files[i]);
                    continue;
                }
                files[i].delete();
            }
        }
        return dir.delete();
    }
}

