/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.batch.openapi;

import java.io.Serializable;

import jp.terasoluna.fw.batch.core.JobException;

/**
 * {WuReLXgNXB
 *
 * <p>
 * Ώۃf[^擾ArWlXWbNAO^㏈ŋLA
 * t[[Nɂ{ݒ肳B<br> 
 * ʂ̃Wu`ۂɁAJ҂̃Wüp̍ڂɑΉ
 * JX^gĒ`邱ƂłB
 * </p>
 * 
 * <p><strong>gWuReLXgBean`</strong></p>
 * 
 * <p>J҂gWuReLXgWuBean`t@Cɐݒ肷B</p>
 * <code><pre>
 *     &lt;bean id=&quot;jobContext&quot;
 *              class=&quot;jp.terasoluna.fw.batch.sample.checksample.SampleJobContext&quot; /&gt;
 * </pre></code>
 * 
 * 
 */
public class JobContext implements Serializable {
    
    /**
     * Serializablepo[WIDB
     */
    private static final long serialVersionUID = 8920476023805712633L;

    /**
     * WuNʁB
     */
    public static enum START_TYPE {
        /**
         * 񓯊B
         */
        ASYNC,
        /**
         * B
         */
        SYNC
    }

    /**
     * WuIDB
     */
    protected String jobId = null;

    /**
     * WuNGXgԍB
     */
    protected String jobRequestNo = null;

    /**
     * Wũp[eBVL[B
     */
    protected String partitionKey = "NO_Partition";
    
    /**
     * Wũp[eBVԍB
     */
    protected int partitionNo = -1;

    /**
     * X^[g\tOB
     */
    protected boolean restartable = false;

    /**
     * X^[gstOB
     */
    protected boolean restarted = false;

    /**
     * X^[g|CgB
     */
    protected int restartPoint = 0;

    /**
     * WuNʁB
     */
    protected START_TYPE startType = null;
    
    /**
     * N̈B
     */
    protected String[] parameter = null;
    
    /**
     * p[eBVL[ݒ肳qWuReLXgԋpB<br>
     * WuAeWuĂ΂B<br>
     * p[eBVԍ̓nhݒ肳B<br>
     *
     * @param partitionKey p[eBVL[
     * @return qWũWuReLXg
     * @throws IllegalArgumentException p[eBVL[NULL܂͋󔒕
     */
    public JobContext getChildJobContext(Object partitionKey) {
        if (partitionKey == null 
                || "".equals(partitionKey.toString().trim())) {
            throw new IllegalArgumentException(
                    "partitionKey is NULL or Whitespace.");
        }
        
        JobContext childJobContext = null;
        try {
            childJobContext = this.getClass().newInstance();
        } catch (InstantiationException e) {
            throw new JobException(e);
        } catch (IllegalAccessException e) {
            throw new JobException(e);
        }
        
        childJobContext.setJobId(this.jobId);
        childJobContext.setJobRequestNo(this.jobRequestNo);
        childJobContext.setRestartable(this.restartable);
        childJobContext.setRestarted(this.restarted);
        childJobContext.setStartType(this.startType);
        childJobContext.setPartitionKey(String.class.cast(partitionKey));
        childJobContext.setParameter(this.parameter);
        
        return childJobContext;
    }

    /**
     * WuIDԋpB
     *
     * @return WuID
     */
    public String getJobId() {
        return this.jobId;
    };

    /**
     * Wu˗ԍԋpB
     *
     * @return Wu˗ԍ
     */
    public String getJobRequestNo() {
        return this.jobRequestNo;
    }

    /**
     * p[eBVL[擾B
     *
     * @return ̃p[eBVL[
     */
    public String getPartitionKey() {
        return this.partitionKey;
    }
    
    /**
     * p[eBVԍԋpB
     *
     * @return p[eBVԍ
     */
    public int getPartitionNo() {
        return this.partitionNo;
    }

    /**
     * X^[g|CgԋpB
     *
     * @return X^[g|Cg
     */
    public int getRestartPoint() {
        return this.restartPoint;
    }

    /**
     * NʂԋpB
     *
     * @return N
     */
    public START_TYPE getStartType() {
        return this.startType;
    }

    /**
     * N̈ԋpB
     * 
     * @return N̈
     */
    public String[] getParameter() {
        return this.parameter;
    }
    
    /**
     * s̃WuX^[g\ȃWuƂĐݒ肳Ă邩擾B
     *
     * @return X^[g\ȃWuł <code>true</code>
     */
    public boolean isRestartable() {
        return this.restartable;
    }

    /**
     * X^[gstO擾B
     *
     * @return X^[gstOB
     *           X^[g|CgĊJꂽWu̎słꍇɂ́A
     *           <code>true</code>
     */
    public boolean isRestarted() {
        return this.restarted;
    }

    /**
     * WuIDݒ肷B
     *
     * @param jobId WuID
     */
    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    /**
     * Wu˗ԍݒ肷B
     *
     * @param jobRequestNo Wu˗ԍ
     */
    public void setJobRequestNo(String jobRequestNo) {
        this.jobRequestNo = jobRequestNo;
    }

    /**
     * N̈WuReLXgɐݒ肷B
     *
     * @param arg NɎw肵3ȍ~̒l
     */
    public void setParameter(String[] arg) {
        this.parameter = arg;
    }

    /**
     * p[eBVԍݒ肷B
     *
     * @param partitionNo p[eBVԍ
     */
    public void setPartitionNo(int partitionNo) {
        this.partitionNo = partitionNo;
    }

    /**
     * s̃WuX^[g\ȃWuǂݒ肷B
     * 
     * <p>t[[NɂăWuɐݒ肳</p>
     *
     * @param restartable X^[g\ȃWuł <code>true</code>
     */
    public void setRestartable(boolean restartable) {
        this.restartable = restartable;
    }

    /**
     * X^[gstOݒ肷B
     * 
     * <p>X^[gstÓAt[[NɂăWuɐݒ肳
     * </p>
     *
     * @param restarted
     *           X^[g|CgĊJꂽWu̎słꍇɂ́A
     *           <code>true</code>
     */
    public void setRestarted(boolean restarted) {
        this.restarted = restarted;
    }

    /**
     * X^[g|Cgݒ肷B
     *
     * <p>X^[g|CǵAt[[NɂăWuɐݒ肳
     * </p>
     * 
     * @param restartPoint X^[g|Cg
     */
    public void setRestartPoint(int restartPoint) {
        this.restartPoint = restartPoint;
    }

    /**
     * Nʂݒ肷B
     *
     * <p>Nʂ́At[[NɂăWuɐݒ肳</p>
     * 
     * @param startType N
     */
    public void setStartType(START_TYPE startType) {
        this.startType = startType;
    }
    
    /**
     * p[eBVL[ݒ肷B
     *
     * <p>p[eBVL[́AWuAt[[NɂĎqWu
     * WuReLXgɐݒ肳</p>
     * 
     * @param partitionKey p[eBVL[
     */
    public void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }
    
}
