/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.file.dao.standard;

import java.io.IOException;
import java.io.Reader;

import jp.terasoluna.fw.file.dao.FileException;


/**
 * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
 * 
 *
 */
public class EncloseCharLineFeed2LineReader implements LineReader {

    /**
     * ؂蕶B
     */
    private char delimiterCharacter = Character.MIN_VALUE;
    
    /**
     * ͂ݕB
     */
    private char encloseCharacter = Character.MIN_VALUE;
    
    /**
     * t@CANZXp̕Xg[B
     */
    private Reader reader = null;
    
    /**
     * s؂蕶B
     */
    private String lineFeedChar = null;
    
    /**
     * RXgN^B
     * @param delimiterCharacter ؂蕶
     * @param encloseCharacter ͂ݕ
     * @param reader t@CANZXp̕Xg[
     * @param lineFeedChar s؂蕶
     * @throws IllegalArgumentException ̐ݒ肪ԈꍇB
     */
    public EncloseCharLineFeed2LineReader(char delimiterCharacter,
            char encloseCharacter, Reader reader, String lineFeedChar) {
        
        if (delimiterCharacter == Character.MIN_VALUE) {
            throw new IllegalArgumentException(
                    "delimiterCharacter can not use '\\u0000'.");
        }
        
        if (encloseCharacter == Character.MIN_VALUE) {
            throw new IllegalArgumentException(
                    "encloseCharacter can not use '\\u0000'.");
        }
        
        if (reader == null) {
            throw new IllegalArgumentException("reader is required.");
        }
        
        if (lineFeedChar == null) {
            throw new IllegalArgumentException("lineFeedChar is required.");
        } 
        
        if (lineFeedChar.length() != 2) {
            throw new IllegalArgumentException("lineFeedChar should be defined"
                    + " by 2 digit of character string.");
        }

        this.delimiterCharacter = delimiterCharacter;
        this.encloseCharacter = encloseCharacter;
        this.reader = reader;
        this.lineFeedChar = lineFeedChar;
    }
    
    /**
     * t@Cf[^̃f[^1sǂݎAƂČďoɕԋpB
     * 
     * @return f[^̂Ps̕
     * @throws FileException ReadeȑŗOꍇB
     */
    public String readLine() {
        
        // 1J̕i[obt@
        StringBuilder currentLineStringBuilder = new StringBuilder();
        
        // `FbNΏە̒O̕
        char previousChar = Character.MIN_VALUE;
        
        // `FbNΏە
        char currentChar = Character.MIN_VALUE;

        // ͂ݕIĂ邩mFtOBtrueȂJ͈͂ݕň͂܂ĂB
        boolean isEnclosed = true;
        
        // GXP[vV[PXǂݍ񂾂trueɁBȊȌꍇfalseB
        boolean isEscape = false;

        // s؂蕶1ځB
        char lineFeedChar1 = lineFeedChar.charAt(0);
        
        // s؂蕶2ځB
        char lineFeedChar2 = lineFeedChar.charAt(1);

        try {
            while (reader.ready()) {
                currentChar = (char) reader.read();
                if (previousChar == Character.MIN_VALUE) {
                    previousChar = currentChar;
                }
                if (previousChar == encloseCharacter) {
                    if (isEnclosed) {
                        if (currentChar == encloseCharacter) {
                            isEnclosed = false;
                            currentLineStringBuilder.append(currentChar);
                        }
                    } else {
                        if (currentChar == encloseCharacter
                                && !isEscape) {
                            isEscape = true;
                        } else if (currentChar == encloseCharacter
                                && isEscape) {
                            isEscape = false;
                            currentLineStringBuilder.append(currentChar);
                            currentLineStringBuilder.append(currentChar);
                        } else if (currentChar == delimiterCharacter) {
                            if (isEscape) {
                                currentLineStringBuilder
                                        .append(encloseCharacter);
                                previousChar = Character.MIN_VALUE;
                                isEnclosed = true;
                                isEscape = false;
                            }
                            currentLineStringBuilder.append(currentChar);
                        } else if (currentChar == lineFeedChar1) {
                            if (isEscape) {
                                currentLineStringBuilder
                                        .append(encloseCharacter);
                                previousChar = currentChar;
                                isEnclosed = true;
                                isEscape = false;
                            }
                            currentLineStringBuilder.append(currentChar);
                        } else {
                            if (isEscape) {
                                currentLineStringBuilder
                                        .append(encloseCharacter);
                                previousChar = currentChar;
                                isEnclosed = true;
                                isEscape = false;
                            }
                            currentLineStringBuilder.append(currentChar);
                        }
                    }
                } else if (previousChar == lineFeedChar1) {
                    if (currentChar == lineFeedChar2) {
                        if (currentLineStringBuilder.length() - 1 >= 0
                                && (currentLineStringBuilder.charAt(
                                        currentLineStringBuilder.length() - 1)
                                        == lineFeedChar1)) {
                            currentLineStringBuilder
                                    .deleteCharAt(currentLineStringBuilder
                                            .length() - 1);
                            previousChar = Character.MIN_VALUE;
                            isEnclosed = true;
                            isEscape = false;
                            break;
                        }
                    }
                    currentLineStringBuilder.append(currentChar);
                } else {
                    if (currentChar == delimiterCharacter) {
                        currentLineStringBuilder.append(currentChar);
                        previousChar = Character.MIN_VALUE;
                        isEnclosed = true;
                        isEscape = false;
                    } else if (currentChar == lineFeedChar2) {
                        if (currentLineStringBuilder.length() - 1 >= 0
                                && (currentLineStringBuilder.charAt(
                                        currentLineStringBuilder.length() - 1))
                                        == lineFeedChar1) {
                            currentLineStringBuilder
                                    .deleteCharAt(currentLineStringBuilder
                                            .length() - 1);
                            previousChar = Character.MIN_VALUE;
                            isEnclosed = true;
                            isEscape = false;
                            break;
                        } else {
                            currentLineStringBuilder.append(currentChar);
                        }
                    } else {
                        currentLineStringBuilder.append(currentChar);
                    }
                }
            }
        } catch (IOException e) {
            throw new FileException("Reader control operation was failed.", e);
        }
        
        return currentLineStringBuilder.toString();
    }

}
