/*
 * Copyright (c) 2007 NTT DATA Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package jp.terasoluna.fw.util;

import java.io.File;

/**
 * t@C֘Ã[eBeBNXB
 *
 * <p>
 *  ZbVIDɑΉfBNg̍쐬A擾A폜sB
 *  eZbVIDɑΉfBNǵA ApplicationRecoures 
 *  t@C &quot;session.dir.base&quot; ŎꂽfBNg̒
 *  쐬B<br>
 *  ZbVɑΉfBNǵAT[oō쐬PDF̒[Ȃ
 *  ZbVɕRtꎞIȃf[^i[ۂɗpłB<br>
 *  ZbVɕRtfBNǵA HttpSession 
 *  IuWFNgꂽۂɁÃ[eBeBNX̃\bh
 *  pč폜B<br>
 *  ZbV̐EjĎ@\ɂẮA
 *  HttpSessionListenerQƁB
 * </p>
 *
 */
public class FileUtil {

    /**
     * ZbVɑΉtꂽfBNg쐬ۂɁAefBNg
     * i[efBNg  ApplicationResource 
     * t@C擾邽߂̃L[B
     */
    private static final String SESSION_DIR_BASE_KEY = "session.dir.base";

    /**
     * w肳ꂽZbVIDɑΉfBNg擾B
     *
     * @param sessionId ZbVID
     * @return ZbVID̃nbVlƂĐꂽfBNg
     */
    public static String getSessionDirectoryName(String sessionId) {
        byte[] hash = HashUtil.hashSHA1(sessionId);
        return StringUtil.toHexString(hash, "");
    }

    /**
     * w肳ꂽZbVIDɑΉfBNg擾B
     * 
     * <p>
     * vpeBL[̐ݒsȂȂꍇA
     * ͋󕶎̏ꍇ tempfBNgpB
     * </p>
     * @param sessionId ZbVID
     * @return ZbVIDɑΉfBNgƂȂt@CIuWFNg
     */
    public static File getSessionDirectory(String sessionId) {
        String dirBase = PropertyUtil.getProperty(SESSION_DIR_BASE_KEY);

        if (dirBase == null || "".equals(dirBase)) {
            dirBase = File.separator + "temp";
        }

        String dirName = getSessionDirectoryName(sessionId);
        return new File(dirBase + File.separator + dirName);
    }

    /**
     * w肳ꂽZbVIDɑΉfBNg쐬B
     *
     * <p>쐬ꍇɂ́Atrue ԂB</p>
     *
     * @param sessionId ZbVID
     * @return fBNg̍쐬ɐ true
     */
    public static boolean makeSessionDirectory(String sessionId) {
        if (sessionId == null || "".equals(sessionId)) {
            return false;
        }
        return getSessionDirectory(sessionId).mkdirs();
    }

    /**
     * w肳ꂽZbVIDɑΉfBNg폜B
     *
     * <p>폜ꍇɂ́Atrue ԂB</p>
     *
     * @param sessionId ZbVID
     * @return fBNg̍폜ɐ true 
     */
    public static boolean removeSessionDirectory(String sessionId) {
        return rmdirs(getSessionDirectory(sessionId));
    }

    /**
     * w肳ꂽfBNg폜B
     *
     * <p>fBNgɃt@CAfBNg
     * ꍇłAċAIɍ폜B</p>
     *
     * @param dir 폜fBNg
     * @return fBNg̍폜ɐ true
     */
    public static boolean rmdirs(File dir) {
        if (dir == null) {
            return false;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; i++) {
                if (files[i].isDirectory()) {
                    rmdirs(files[i]);
                } else {
                    files[i].delete();
                }
            }
        }
        return dir.delete();
    }
}
