/*******************************************************************************
 * Copyright (c) 2009 IGA Tosiki, NTT DATA BUSINESS BRAINS Corp.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    IGA Tosiki (NTT DATA BUSINESS BRAINS Corp.) - initial API and implementation
 *******************************************************************************/
/*
 * blanco Framework
 * Copyright (C) 2009 NTT DATA BUSINESS BRAINS CORPORATION
 * 
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 */
package blanco.pdf.report.sample;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;

import junit.framework.TestCase;
import blanco.pdf.valueobject.BlancoPdfSetting;
import blanco.sample.pdf.report.Yoko01PdfReport;
import blanco.sample.pdf.report.items.Yoko01PdfReportItems;

/**
 * ꂽ\[XR[h𗘗p󎚂̗B
 */
public class BlancoPdfReportTest extends TestCase {
    public void testReport() throws Exception {
        new File("./tmp/pdf/").mkdirs();
        final OutputStream outStream = new BufferedOutputStream(
                new FileOutputStream("./tmp/pdf/aaa.pdf"));
        final BlancoPdfSetting setting = new BlancoPdfSetting();
        setting.setConfPath("./test/conf/pdf");
        final Yoko01PdfReport report = new Yoko01PdfReport(setting, outStream);
        final Yoko01PdfReportItems pdfItems = new Yoko01PdfReportItems();
        pdfItems.setField00("^Cg");
        pdfItems.setField01("Tv");
        pdfItems.setField02("`abcdef");
        report.writeItems(pdfItems);

        report.nextPage();
        report.drawGridSheet();
        report.writeItems(pdfItems);

        report.close();
        outStream.flush();
        outStream.close();
    }
}
