package hayashi.yuu.tools.mail.gui;

import hayashi.yuu.tools.mail.SiteData;
import hayashi.yuu.tools.properties.Properties;
import hayashi.yuu.tools.properties.PropertyFieldItem;
import hayashi.yuu.tools.properties.PropertyItem;

import java.awt.Dimension;

import javax.swing.BoxLayout;
import javax.swing.JPanel;


/**
 * <メール配信先>セットアップフォーム：
 * (1)アイテム: [ MAIL_TO ]
 * (2)アイテム: [ MAIL_CC ]
 * (3)アイテム: [ MAIL_BCC ]
 */
@SuppressWarnings("serial")
public class MailAddrPanel extends JPanel
{
    public static final int LINE_COUNT = 3;
    public static final int CATEGORY_HEIGHT = PropertyItem.LINE_HEIGHT * LINE_COUNT;

    PropertyFieldItem iTo;			// 'MAIL_TO'　メール送信先 : 宛先
    PropertyFieldItem iCc;			// 'MAIL_CC'　メール送信先 : カーボンコピー
    PropertyFieldItem iBcc;			// 'MAIL_BCC'　メール送信先 : ブラックカーボンコピー
    
	public MailAddrPanel(Properties prop) {
		super();

		/*
		 * カテゴリの配置
		 */
	    setLayout(new BoxLayout(this, BoxLayout.Y_AXIS));

		/*
		 * (1)アイテム: [ MAIL_TO ]
		 */
		iTo = new PropertyFieldItem(prop, "MAIL_TO", "宛先", true);
		add(iTo);
		iTo.setBounds(0, PropertyItem.LINE_HEIGHT * 8, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);
		
		/*
		 * (2)アイテム: [ MAIL_CC ]
		 */
		iCc = new PropertyFieldItem(prop, "MAIL_CC", "CC", true);
		add(iCc);
		iCc.setBounds(0, PropertyItem.LINE_HEIGHT * 9, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);
		
		/*
		 * (3)アイテム: [ MAIL_BCC ]
		 */
		iBcc = new PropertyFieldItem(prop, "MAIL_BCC", "BCC", true);
		add(iBcc);
		iBcc.setBounds(0, PropertyItem.LINE_HEIGHT * 10, PropertyItem.LINE_WIDTH, PropertyItem.LINE_HEIGHT);
		
		setPreferredSize(new Dimension(PropertyItem.LINE_WIDTH, CATEGORY_HEIGHT));
	}
	
	public SiteData getSiteData(SiteData data) {
		/*
		 * (9)アイテム: [ MAIL_TO ]
		 */
		data.MAIL_TO = iTo.getValue();
		
		/*
		 * (10)アイテム: [ MAIL_CC ]
		 */
		data.MAIL_CC = iCc.getValue();
		
		/*
		 * (11)アイテム: [ MAIL_BCC ]
		 */
		data.MAIL_BCC = iBcc.getValue();
		
		return data;
	}
}
