/*
  This file is part of f-palette-CANopen

  2011/11/08
  Copyright (C): Future Robotics Technology Center, Chiba institute of technology
  TI F2803x Port: Masaharu Shimizu@Future Robotics Technology Center, Chiba institute of technology
  
  This work is based on
   -    Canfestival
        http://sourceforge.net/projects/canfestival/
  Copyright (C): Edouard TISSERANT and Francis DUPIN

See COPYING file for copyrights details.

This library is free software; you can redistribute it and/or
modify it under the terms of the GNU Lesser General Public
License as published by the Free Software Foundation; either
version 2.1 of the License, or (at your option) any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
Lesser General Public License for more details.

You should have received a copy of the GNU Lesser General Public
License along with this library; if not, write to the Free Software
Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/


//## Include header files
#include "DSP2803x_Device.h"     // DSP2803x Headerfile Include File
#include "DSP2803x_Examples.h"   // DSP2803x Examples Include File

#include "canfestival.h"
#include "ObjDict.h"


//## Declaration Define
#define		ADC_NUM		8

/* CAN open parameters */
#define		NODE_ID		0x05
#define		CAN_BAUDRATE	500		/* kbps */
/* 10,20,50,100,125,250,500,1000 kbps  see driver can_TI_F2803x.c */


//## Define constant nunber

/* FlashE  function */
#pragma CODE_SECTION(set_outputs, "flashE");
#pragma CODE_SECTION(read_ADCinput, "flashE");
#pragma CODE_SECTION(Gpio_setup, "flashE");
#pragma CODE_SECTION(startAdc, "flashE");
#pragma CODE_SECTION(ObjDict_scanIndexOD, "flashE");

// Prototype statements for functions found within this file.
interrupt void cpu_timer0_isr(void);

UNS8 get_inputs(void);
void set_outputs(UNS8);
void read_ADCinput(Uint16 setdata[ADC_NUM]);

void Gpio_setup(void);
void setupinterrupt(void);
void startAdc(void);


//## Declaration parameters
UNS8	u8NodeID;
UNS8	u8digital_input_8bit[1];
UNS8	u8digital_Output_8bit[1];
Uint16		ADCResult[ADC_NUM];

/* ============================================================================================ */
/* ## main function */
/* ============================================================================================ */
void main(void)
{
//	Uint32 i;
	
// Step 1. Initialize System Control:
// PLL, WatchDog, enable Peripheral Clocks
// This example function is found in the DSP2803x_SysCtrl.c file.
   InitSysCtrl();
// Copy time critical code and Flash setup code to RAM
// The  RamfuncsLoadStart, RamfuncsLoadEnd, and RamfuncsRunStart
// symbols are created by the linker. Refer to the F28035.cmd file. 
   MemCopy(&RamfuncsLoadStart, &RamfuncsLoadEnd, &RamfuncsRunStart);
   InitFlash();
// Step 2. Initalize GPIO: 
// This example function is found in the DSP2803x_Gpio.c file and
// illustrates how to set the GPIO to it's default state.
   InitECanaGpio();//GPI30,GPIO31
   Gpio_setup();//
// Step 3. Clear all interrupts and initialize PIE vector table:
	setupinterrupt();
// Step 4. Initialize all the Device Peripherals:
// This function is found in DSP2803x_InitPeripherals.c
// InitPeripherals(); // Not required for this example
   InitAdc();  //  init the ADC
   startAdc();
   InitCpuTimers();   // Iinitialize the Cpu Timers

// Configure CPU-Timer 0 to interrupt every second:
// 60MHz CPU Freq, 1 second Period (in uSeconds)
	ConfigCpuTimer(&CpuTimer0, 60, 1000); //1MHz=1us period x 1000 Count = 1khz intterupt

	initTimer();/* call CanFestival function */
	u8NodeID = NODE_ID;
	setNodeId (&ObjDict_Data, u8NodeID);
	canInit(CAN_BAUDRATE);/* call between setNodeId and setState */ 
	setState(&ObjDict_Data, Initialisation);	// Init the state
  
   EALLOW;
   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 0;
   EDIS;  

   EALLOW;
   SysCtrlRegs.PCLKCR0.bit.TBCLKSYNC = 1;
   EDIS;

// Step 5. User specific code, enable interrupts:
// Enable CPU INT1 which is connected to CPU-Timer 0:
   IER |= M_INT1;
// Enable TINT0 in the PIE: Group 1 interrupt 7
   PieCtrlRegs.PIEIER1.bit.INTx7 = 1;

// Enable global Interrupts and higher priority real-time debug events:
   EINT;   // Enable Global interrupt INTM
   ERTM;   // Enable Global realtime interrupt DBGM

// Step 6. IDLE loop. Just sit and loop forever (optional):

   /*-------------------------------------------------------------------------------------------*/
   /*-------------------------------------------------------------------------------------------*/
   StartCpuTimer0();

   for(;;)
   {
        asm("          NOP");
   }
} 

//## CPU timer interrupt
interrupt void cpu_timer0_isr(void)
{
	 unsigned char transmission;

	AdcRegs.ADCSOCFRC1.all	= 0x00FF;	/* Start of conversion SOC0 to SOC7 */	
	
// Cycle timer, invoke action on every time slice 
	u8digital_input_8bit[0] = get_inputs();
	transmission = 	digital_input_handler(&ObjDict_Data, u8digital_input_8bit, sizeof(u8digital_input_8bit));
	digital_output_handler(&ObjDict_Data, u8digital_Output_8bit, sizeof(u8digital_Output_8bit));
	set_outputs(u8digital_Output_8bit[0]);
	read_ADCinput(ADCResult);
	transmission+=	analog_input_handler(&ObjDict_Data, ADCResult, sizeof(ADCResult));

	if (transmission){/* Not Zero */
  /* force emission of PDO by artificially changing last emitted */
		transmission_sendPDOevent(&ObjDict_Data);
	}
	
	// Acknowledge this interrupt to receive more interrupts from group 1
	PieCtrlRegs.PIEACK.all = PIEACK_GROUP1;
}

//## CAN functions
/* ## CAN functions */
/*==============================================================================================*/

UNS8 get_inputs(void){
	Uint16 tmp;
	tmp = 0;	
	tmp = 	(GpioDataRegs.GPADAT.bit.GPIO0 << 0)
		+	(GpioDataRegs.GPADAT.bit.GPIO2 << 1)
		+	(GpioDataRegs.GPADAT.bit.GPIO4 << 2)
		+	(GpioDataRegs.GPADAT.bit.GPIO6 << 3)
		+	(GpioDataRegs.GPADAT.bit.GPIO8 << 4)
		+	(GpioDataRegs.GPADAT.bit.GPIO10 << 5)
		+	(GpioDataRegs.GPBDAT.bit.GPIO42 << 6)
		+	(GpioDataRegs.GPBDAT.bit.GPIO44 << 7);
	return (UNS8)tmp;	
}
	
void set_outputs(UNS8 set_data){
	Uint16 tmp;
	Uint32 dumyread32;
	tmp = (Uint16)set_data;	
	GpioDataRegs.GPADAT.bit.GPIO1	= (tmp & 0x0001); /* bit0 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPADAT.bit.GPIO3	= (tmp & 0x0001); /* bit1 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPADAT.bit.GPIO7	= (tmp & 0x0001); /* bit2 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPADAT.bit.GPIO5	= (tmp & 0x0001); /* bit3 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPBDAT.bit.GPIO40	= (tmp & 0x0001); /* bit4 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPBDAT.bit.GPIO41	= (tmp & 0x0001); /* bit5 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPADAT.bit.GPIO9	= (tmp & 0x0001); /* bit6 */
	tmp =(tmp >> 1);
	GpioDataRegs.GPADAT.bit.GPIO11	= (tmp & 0x0001); /* bit7 */

	/* dummy read */
	dumyread32 = GpioDataRegs.GPADAT.all;
	dumyread32 = GpioDataRegs.GPBDAT.all;
	return;	
}

void read_ADCinput(Uint16 setdata[]){
	/* shift up upper bits : 12bit to 16bit */	
	setdata[0] = (AdcResult.ADCRESULT0 << 4);
	setdata[1] = (AdcResult.ADCRESULT1 << 4);
	setdata[2] = (AdcResult.ADCRESULT2 << 4);
	setdata[3] = (AdcResult.ADCRESULT3 << 4);
	setdata[4] = (AdcResult.ADCRESULT4 << 4);
	setdata[5] = (AdcResult.ADCRESULT5 << 4);
	setdata[6] = (AdcResult.ADCRESULT6 << 4);
	setdata[7] = (AdcResult.ADCRESULT7 << 4);
	return;	
}

/* -------------------------------------------------------------------------------------------- */
//## Initialize functions
/* -------------------------------------------------------------------------------------------- */

void Gpio_setup(void)
{
/* Enable an GPIO input on GPIO0,2,4,6,8,10,42,44 */
// Enable an GPIO Output on GPIO1,3,5,7,9,11,40,41,43 */

 	EALLOW;
   GpioCtrlRegs.GPAPUD.bit.GPIO0 = 1;   /* Disable pullup GPIO0*/
   GpioCtrlRegs.GPAPUD.bit.GPIO2 = 1;   /* Disable pullup GPIO2*/
   GpioCtrlRegs.GPAPUD.bit.GPIO4 = 1;   /* Disable pullup GPIO4*/
   GpioCtrlRegs.GPAPUD.bit.GPIO6 = 1;   /* Disable pullup GPIO6*/
   GpioCtrlRegs.GPAPUD.bit.GPIO8 = 1;   /* Disable pullup GPIO8*/
   GpioCtrlRegs.GPAPUD.bit.GPIO10 = 1;   /* Disable pullup GPIO10*/
   GpioCtrlRegs.GPBPUD.bit.GPIO42 = 0;   // Disable pullup on GPIO42
   GpioCtrlRegs.GPBPUD.bit.GPIO44 = 0;   // Disable pullup on GPIO44
   GpioCtrlRegs.GPAMUX1.bit.GPIO0 = 0;  /* GPIO0 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO2 = 0;  /* GPIO2 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO4 = 0;  /* GPIO4 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO6 = 0;  /* GPIO6 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO8 = 0;  /* GPIO8 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO10 = 0;  /* GPIO10 = GPIO */
   GpioCtrlRegs.GPBMUX1.bit.GPIO42 = 0;  // GPIO42 = GPIO
   GpioCtrlRegs.GPBMUX1.bit.GPIO44 = 0;  // GPIO44 = GPIO
   GpioCtrlRegs.GPADIR.bit.GPIO0 = 0;   // input 
   GpioCtrlRegs.GPADIR.bit.GPIO2 = 0;   // input 
   GpioCtrlRegs.GPADIR.bit.GPIO4 = 0;   // input 
   GpioCtrlRegs.GPADIR.bit.GPIO6 = 0;   // input 
   GpioCtrlRegs.GPADIR.bit.GPIO8 = 0;   // input 
   GpioCtrlRegs.GPADIR.bit.GPIO10 = 0;   // input  
   GpioCtrlRegs.GPBDIR.bit.GPIO42 = 0;   // GPIO42 = input
   GpioCtrlRegs.GPBDIR.bit.GPIO44 = 0;   // GPIO42 = intput
  
  
   GpioCtrlRegs.GPAPUD.bit.GPIO1 = 0;   /* Enable pullup GPIO1*/
   GpioCtrlRegs.GPAPUD.bit.GPIO3 = 0;   /* Enable pullup GPIO3*/
   GpioCtrlRegs.GPAPUD.bit.GPIO5 = 0;   /* Enable pullup GPIO5*/
   GpioCtrlRegs.GPAPUD.bit.GPIO7 = 0;   /* Enable pullup GPIO7*/
   GpioCtrlRegs.GPAPUD.bit.GPIO9 = 0;   /* Enable pullup GPIO9*/
   GpioCtrlRegs.GPAPUD.bit.GPIO11 = 0;   /* Enable pullup GPIO11*/
   GpioCtrlRegs.GPBPUD.bit.GPIO40 = 0;   /* Enable pullup GPIO40*/
   GpioCtrlRegs.GPBPUD.bit.GPIO41 = 0;   /* Enable pullup GPIO41*/
   GpioCtrlRegs.GPBPUD.bit.GPIO43 = 0;   /* Enable pullup GPIO43*/
   GpioCtrlRegs.GPAMUX1.bit.GPIO1 = 0;  /* GPIO1 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO3 = 0;  /* GPIO3 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO5 = 0;  /* GPIO5 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO7 = 0;  /* GPIO7 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO9 = 0;  /* GPIO9 = GPIO */
   GpioCtrlRegs.GPAMUX1.bit.GPIO11 = 0;  /* GPIO11 = GPIO */ 
   GpioCtrlRegs.GPBMUX1.bit.GPIO40 = 0;  /* GPIO40 = GPIO */
   GpioCtrlRegs.GPBMUX1.bit.GPIO41 = 0;  /* GPIO41 = GPIO */
   GpioCtrlRegs.GPBMUX1.bit.GPIO43 = 0;  /* GPIO43 = GPIO */
   GpioCtrlRegs.GPADIR.bit.GPIO1 = 1;   // GPIO1 = output
   GpioCtrlRegs.GPADIR.bit.GPIO3 = 1;   // GPIO3 = output
   GpioCtrlRegs.GPADIR.bit.GPIO5 = 1;   // GPIO5 = output
   GpioCtrlRegs.GPADIR.bit.GPIO7 = 1;   // GOIO7 = output
   GpioCtrlRegs.GPADIR.bit.GPIO9 = 1;   // GPIO9 = output
   GpioCtrlRegs.GPADIR.bit.GPIO11 = 1;   // GOIO11 = output
   GpioCtrlRegs.GPBDIR.bit.GPIO40 = 1;   // GOIO40 = output
   GpioCtrlRegs.GPBDIR.bit.GPIO41 = 1;   // GOIO41 = output
   GpioCtrlRegs.GPBDIR.bit.GPIO43 = 1;   // GOIO43 = output
  
      
   GpioCtrlRegs.GPBPUD.bit.GPIO39 = 1;   // Disable pullup on GPIO39
   GpioDataRegs.GPBSET.bit.GPIO39 = 1;   // Load output latch
   GpioCtrlRegs.GPBMUX1.bit.GPIO39 = 0;  // GPIO39 = GPIO39
   GpioCtrlRegs.GPBDIR.bit.GPIO39 = 1;   // GPIO39 = output

	 EDIS;
}

/* -------------------------------------------------------------------------------------------- */
void setupinterrupt(void)
{

// Disable CPU interrupts 
   DINT;

// Initialize the PIE control registers to their default state.
// The default state is all PIE interrupts disabled and flags
// are cleared.  
// This function is found in the DSP2803x_PieCtrl.c file.
   InitPieCtrl();
   
// Disable CPU interrupts and clear all CPU interrupt flags:
   IER = 0x0000;
   IFR = 0x0000;

// Initialize the PIE vector table with pointers to the shell Interrupt 
// Service Routines (ISR).  
// This will populate the entire table, even if the interrupt
// is not used in this example.  This is useful for debug purposes.
// The shell ISR routines are found in DSP2803x_DefaultIsr.c.
// This function is found in DSP2803x_PieVect.c.
   InitPieVectTable();

// Interrupts that are used in this example are re-mapped to
// ISR functions found within this file.  
   EALLOW;  // This is needed to write to EALLOW protected registers
   PieVectTable.TINT0 = &cpu_timer0_isr;
   EDIS;    // This is needed to disable write to EALLOW protected registers 

}

/* -------------------------------------------------------------------------------------------- */
/* ============================================================================================ */
/* AdcResult.ADCRESULT0: ADC1INA0																*/
/* AdcResult.ADCRESULT1: ADC1INA1																*/
/* AdcResult.ADCRESULT2: ADC1INA2																*/
/* AdcResult.ADCRESULT3: ADC1INA3																*/
/* AdcResult.ADCRESULT4: ADC1INA4																*/
/* AdcResult.ADCRESULT5: ADC1INA5																*/
/* AdcResult.ADCRESULT6: ADC1INA6																*/
/* AdcResult.ADCRESULT7: ADC1INA7																*/
/* -------------------------------------------------------------------------------------------- */
void startAdc(void){
	Uint16	i;
// Configure ADC
	EALLOW;
	AdcRegs.ADCCTL1.bit.INTPULSEPOS	= 1;	//ADCINT1 trips after AdcResults latch
	AdcRegs.INTSEL1N2.bit.INT1E     = 0;	//Disabled ADCINT1
	AdcRegs.INTSEL1N2.bit.INT1CONT  = 0;	//Disable ADCINT1 Continuous mode

	AdcRegs.ADCSOC0CTL.bit.CHSEL 	= 0;	//set SOC0 channel select to ADCINA0
	AdcRegs.ADCSOC1CTL.bit.CHSEL 	= 1;	//set SOC1 channel select to ADCINA1
	AdcRegs.ADCSOC2CTL.bit.CHSEL 	= 2;	//set SOC2 channel select to ADCINA2
	AdcRegs.ADCSOC3CTL.bit.CHSEL 	= 3;	//set SOC3 channel select to ADCINA3
	AdcRegs.ADCSOC4CTL.bit.CHSEL 	= 4;	//set SOC4 channel select to ADCINA4
	AdcRegs.ADCSOC5CTL.bit.CHSEL 	= 5;	//set SOC5 channel select to ADCINA5
	AdcRegs.ADCSOC6CTL.bit.CHSEL 	= 6;	//set SOC6 channel select to ADCINA6
	AdcRegs.ADCSOC7CTL.bit.CHSEL 	= 7;	//set SOC7 channel select to ADCINA7

	AdcRegs.ADCSOC0CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC1CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC2CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC3CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC4CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC5CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC6CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1
	AdcRegs.ADCSOC7CTL.bit.TRIGSEL 	= 0;	//set SOC0 start trigger on Softwear, due to round-robin SOC0 converts first then SOC1

	AdcRegs.ADCSOC0CTL.bit.ACQPS 	= 6;	//set SOC0 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC1CTL.bit.ACQPS 	= 6;	//set SOC1 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC2CTL.bit.ACQPS 	= 6;	//set SOC2 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC3CTL.bit.ACQPS 	= 6;	//set SOC3 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC4CTL.bit.ACQPS 	= 6;	//set SOC4 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC5CTL.bit.ACQPS 	= 6;	//set SOC5 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC6CTL.bit.ACQPS 	= 6;	//set SOC6 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)
	AdcRegs.ADCSOC7CTL.bit.ACQPS 	= 6;	//set SOC7 S/H Window to 7 ADC Clock Cycles, (6 ACQPS plus 1)

	EDIS;
	
	for(i = 0;i < ADC_NUM;i++){
		ADCResult[i] = 0;
	}
	/* start fast conversion */
	AdcRegs.ADCSOCFRC1.all	= 0x00FF;	/* Start of conversion SOC0 to SOC7 */	

	return;
}
/* ============================================================================================ */
/* No more. */
/* ============================================================================================ */

