/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.engine;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Arrays;
import org.maachang.util.ConvertParam;
import org.maachang.util.FileUtil;

public class MHash {
    public static final int MAX_HASH_SIZE = 0x100000;
    private static final int MAX_SEQUENCE_ID = 64;
    private RandomAccessFile fp = null;
    private MappedByteBuffer map = null;
    private String filename = null;
    private final byte[] tmp = new byte[4];

    private MHash() {
    }

    public MHash(String filename) throws Exception {
        if (filename == null || (filename = filename.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        filename = FileUtil.getFullPath(filename);
        boolean isFile = FileUtil.isFileExists(filename);
        RandomAccessFile fp = new RandomAccessFile(filename, "rwd");
        if (!isFile) {
            MHash.initFile(fp);
        }
        FileChannel channel = fp.getChannel();
        MappedByteBuffer map = channel.map(FileChannel.MapMode.READ_WRITE, 0L, fp.length());
        this.fp = fp;
        this.map = map;
        this.filename = filename;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public synchronized void destroy() {
        if (this.map != null) {
            try {
                this.map.force();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.fp != null) {
            try {
                this.fp.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.fp = null;
        this.map = null;
        this.filename = null;
    }

    public synchronized void flush() throws Exception {
        if (this.map != null) {
            this.map.force();
        }
    }

    public synchronized void put(int hash, int pos) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (hash <= -1 || hash >= 0x100000) {
            throw new IllegalArgumentException("\u6307\u5b9aHash\u30b3\u30fc\u30c9(" + hash + ")\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        this.map.position(hash * 4);
        this.map.put(ConvertParam.convertInt(pos));
    }

    public synchronized void remove(int hash) throws Exception {
        this.put(hash, -1);
    }

    public synchronized int get(int hash) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (hash <= -1 || hash >= 0x100000) {
            throw new IllegalArgumentException("\u6307\u5b9aHash\u30b3\u30fc\u30c9(" + hash + ")\u306f\u7bc4\u56f2\u5916\u3067\u3059");
        }
        this.map.position(hash * 4);
        byte[] b = this.tmp;
        this.map.get(b);
        return ConvertParam.convertInt(0, b);
    }

    public synchronized String getFileName() {
        if (!this.check()) {
            return null;
        }
        return this.filename;
    }

    public synchronized long sequenceId(int no) throws Exception {
        if (!this.check()) {
            throw new IOException("\u65e2\u306b\u7834\u68c4\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        if (no < 0 || no >= 64) {
            return -1L;
        }
        byte[] b = new byte[8];
        int off = 0x400000 + no * 8;
        this.map.position(off);
        this.map.get(b);
        long ret = ConvertParam.convertLong(0, b);
        b = null;
        ret = ret >= Long.MAX_VALUE ? 0L : ++ret;
        this.map.position(off);
        this.map.put(ConvertParam.convertLong(ret));
        return ret;
    }

    public synchronized boolean isUse() {
        return this.check();
    }

    private boolean check() {
        return this.fp != null && this.map != null;
    }

    private static final void initFile(RandomAccessFile fp) throws Exception {
        int off = 0x400000;
        byte[] b = new byte[off + 512];
        Arrays.fill(b, (byte)-1);
        int i = 0;
        while (i < 64) {
            b[off] = 0;
            b[off + 1] = 0;
            b[off + 2] = 0;
            b[off + 3] = 0;
            b[off + 4] = 0;
            b[off + 5] = 0;
            b[off + 6] = 0;
            b[off + 7] = 0;
            off += 8;
            ++i;
        }
        fp.write(b);
    }
}

