/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.dbm.service.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.maachang.dbm.service.client.ResultClientQueue;
import org.maachang.util.ConvertParam;

class ClientSession {
    private Socket socket = null;
    private InputStream input = null;
    private OutputStream output = null;
    private ResultClientQueue queue = null;
    private boolean receiveFlag = false;
    private final Object sync = new Object();
    private Object driverSync = null;
    private static final int RECV_TIMEOUT = 5000;
    private static final int CONN_TIMEOUT = 2500;
    private static final int BASE_BUFFER = 262144;

    public ClientSession(Object driverSync, InetAddress addr, int port) throws Exception {
        if (addr == null) {
            addr = InetAddress.getByName("127.0.0.1");
        }
        if (port < 0 || port > 65535) {
            port = 9801;
        }
        this.driverSync = driverSync;
        this.socket = ClientSession.createSocket(addr, port);
        this.input = new BufferedInputStream(this.socket.getInputStream());
        this.output = new BufferedOutputStream(this.socket.getOutputStream());
        this.queue = new ResultClientQueue();
    }

    private static final Socket createSocket(InetAddress addr, int port) throws Exception {
        Socket ret = new Socket();
        ret.setSendBufferSize(262144);
        ret.setReceiveBufferSize(262144);
        ret.setSoLinger(false, 0);
        ret.setKeepAlive(true);
        ret.setTcpNoDelay(true);
        ret.setReuseAddress(true);
        ret.connect(new InetSocketAddress(addr, port), 2500);
        ret.setSoTimeout(5000);
        return ret;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.sync;
        synchronized (object) {
            if (this.input != null) {
                try {
                    this.input.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.output != null) {
                try {
                    this.output.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.socket != null) {
                try {
                    this.socket.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.queue = null;
            this.socket = null;
            this.input = null;
            this.output = null;
            this.receiveFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InputStream input() {
        InputStream ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.input;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream output() {
        OutputStream ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.output;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Socket socket() {
        Socket ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.socket;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ResultClientQueue getQueue() {
        ResultClientQueue ret = null;
        Object object = this.sync;
        synchronized (object) {
            ret = this.queue;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isUse() {
        boolean ret = true;
        Object object = this.sync;
        synchronized (object) {
            try {
                if (this.socket == null || this.input == null || this.output == null || this.queue == null || !this.queue.isUse() || !this.socket.isBound() || this.socket.isClosed()) {
                    ret = false;
                }
            }
            catch (Exception e) {
                ret = false;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceiveMethod() throws Exception {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            ret = this.receiveFlag;
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReceive() throws Exception {
        boolean ret = false;
        Object object = this.sync;
        synchronized (object) {
            if (!this.isUse()) {
                throw new IOException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            if (this.input.available() > 0) {
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startReceive() {
        Object object = this.sync;
        synchronized (object) {
            this.receiveFlag = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exitReceive() {
        Object object = this.sync;
        synchronized (object) {
            this.receiveFlag = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] receive() {
        ByteArrayOutputStream bs;
        block26: {
            bs = null;
            try {
                int n;
                this.startReceive();
                bs = new ByteArrayOutputStream();
                if (!this.isUse()) {
                    this.destroy();
                    byte[] byArray = null;
                    return byArray;
                }
                int len = -1;
                byte[] ret = null;
                InputStream in = null;
                Object object = this.sync;
                synchronized (object) {
                    in = this.input;
                }
                int cnt = 0;
                while ((n = in.read()) > -1) {
                    byte[] bin;
                    bs.write(n);
                    if (len <= -1 && ++cnt >= 4 && (len = ConvertParam.convertInt(0, bin = bs.toByteArray())) <= 0) {
                        this.sendHeartBeat();
                        byte[] byArray = null;
                        return byArray;
                    }
                    if (len <= 0 || cnt < len) continue;
                    ret = bs.toByteArray();
                    break;
                }
                bs.close();
                bs = null;
                byte[] byArray = ret;
                return byArray;
            }
            catch (SocketTimeoutException len) {
                break block26;
                catch (Exception e) {
                    this.destroy();
                }
            }
            finally {
                if (bs != null) {
                    try {
                        bs.close();
                    }
                    catch (Exception exception) {}
                }
                bs = null;
            }
        }
        if (bs == null) return null;
        try {
            bs.close();
            return null;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public Object getDriverSync() {
        return this.driverSync;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendHeartBeat() throws Exception {
        if (this.output != null) {
            OutputStream outputStream = this.output;
            synchronized (outputStream) {
                this.output.write(ConvertParam.convertInt(0));
                this.output.flush();
            }
        }
    }
}

