package org.maachang.dbm.service ;

import java.io.OutputStream;
import java.util.Enumeration;

import org.maachang.dbm.MDbmManager;
import org.maachang.util.ConvertParam;


/**
 * MDBM実行.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class ExecutionMDbm {
    
    /**
     * セッション実行.
     */
    public static final void execution( byte[] bin,DbmSession session )
        throws Exception {
        if( session == null || session.isClosed() == true ) {
            return ;
        }
        if( bin == null || bin.length < ProtocolDef.SEND_OFFSET ) {
            returnError( session,"不明なプロトコルです" ) ;
            return ;
        }
        if( MDbmManager.getInstance().isClose() == true ) {
            returnError( session,"MDbmマネージャは停止しています" ) ;
            return ;
        }
        try {
            int type = getSendType( bin ) ;
            switch( type ) {
                case ProtocolDef.SEND_CLOSE : resultClose( session ) ; break ;
                case ProtocolDef.SEND_COMMIT : resultCommit( session ) ; break ;
                case ProtocolDef.SEND_ROLLBACK : resultRollback( session ) ; break ;
                case ProtocolDef.SEND_TRANSACTOIN : resultCheck( session ) ; break ;
                case ProtocolDef.SEND_PUT : resultPut( bin,session ) ; break ;
                case ProtocolDef.SEND_REMOVE : resultRemove( bin,session ) ; break ;
                case ProtocolDef.SEND_GET : resultGet( bin,session ) ; break ;
                case ProtocolDef.SEND_CONTAINS : resultContains( bin,session ) ; break ;
                case ProtocolDef.SEND_SIZE : resulSize( session ) ; break ;
                case ProtocolDef.SEND_DIRECTORY : resultDirectory( session ) ; break ;
                case ProtocolDef.SEND_INIT_KEY : resulInitKey( session ) ; break ;
                case ProtocolDef.SEND_HAS_KEY : resulHasKey( session ) ; break ;
                case ProtocolDef.SEND_GET_KEY : resulGetKey( session ) ; break ;
                case ProtocolDef.SEND_SEQUENCE_ID : resultSequenceId( bin,session ) ; break ;
                default : returnError( session,"不明なプロトコルです" ) ; break ;
            }
        } catch( Exception e ) {
            try {
                returnError( session,e.getLocalizedMessage() ) ;
            } catch( Exception ee ) {
                if( session != null ) {
                    session.destroy() ;
                }
            }
        }
    }
    
    /**
     * 命令タイプ取得.
     */
    private static final int getSendType( byte[] bin )
        throws Exception {
        return ConvertParam.convertInt( ProtocolDef.OFFSET,bin ) ;
    }
    
    /**
     * クローズ実行.
     */
    private static final void resultClose( DbmSession session ) throws Exception {
        out( "close" ) ;
        session.mdbm().close() ;
        session.destroy() ;
    }
    
    /**
     * コミット実行.
     */
    private static final void resultCommit( DbmSession session ) throws Exception {
        out( "commit" ) ;
        session.mdbm().commit() ;
        session.clearKeys() ;
        returnSuccess( session ) ;
    }
    
    /**
     * ロールバック実行.
     */
    private static final void resultRollback( DbmSession session ) throws Exception {
        out( "rollback" ) ;
        session.mdbm().rollback() ;
        session.clearKeys() ;
        returnSuccess( session ) ;
    }
    
    /**
     * トランザクションチェック実行.
     */
    private static final void resultCheck( DbmSession session ) throws Exception {
        out( "check" ) ;
        session.mdbm().check() ;
        returnSuccess( session ) ;
    }
    
    /**
     * データPut実行.
     */
    private static final void resultPut( byte[] bin,DbmSession session ) throws Exception {
        out( "put" ) ;
        int pnt = ProtocolDef.SEND_OFFSET ;
        int keyLen = ConvertParam.convertInt( pnt,bin ) ;
        pnt += 4 ;
        byte[] key = new byte[ keyLen ] ;
        System.arraycopy( bin,pnt,key,0,keyLen ) ;
        pnt += keyLen ;
        int valLen = ConvertParam.convertInt( pnt,bin ) ;
        pnt += 4 ;
        byte[] value = new byte[ valLen ] ;
        System.arraycopy( bin,pnt,value,0,valLen ) ;
        session.mdbm().put( key,value ) ;
        key = null ;
        value = null ;
        returnSuccess( session ) ;
    }
    
    /**
     * データRemove実行.
     */
    private static final void resultRemove( byte[] bin,DbmSession session ) throws Exception {
        out( "remove" ) ;
        int pnt = ProtocolDef.SEND_OFFSET ;
        int keyLen = ConvertParam.convertInt( pnt,bin ) ;
        pnt += 4 ;
        byte[] key = new byte[ keyLen ] ;
        System.arraycopy( bin,pnt,key,0,keyLen ) ;
        session.mdbm().remove( key ) ;
        key = null ;
        returnSuccess( session ) ;
    }
    
    /**
     * データGet実行.
     */
    private static final void resultGet( byte[] bin,DbmSession session ) throws Exception {
        out( "get" ) ;
        int pnt = ProtocolDef.SEND_OFFSET ;
        int keyLen = ConvertParam.convertInt( pnt,bin ) ;
        pnt += 4 ;
        byte[] key = new byte[ keyLen ] ;
        System.arraycopy( bin,pnt,key,0,keyLen ) ;
        byte[] ret = session.mdbm().get( key ) ;
        key = null ;
        returnData( session,ret ) ;
    }
    
    /**
     * データContails実行.
     */
    private static final void resultContains( byte[] bin,DbmSession session ) throws Exception {
        out( "contains" ) ;
        int pnt = ProtocolDef.SEND_OFFSET ;
        int keyLen = ConvertParam.convertInt( pnt,bin ) ;
        pnt += 4 ;
        byte[] key = new byte[ keyLen ] ;
        System.arraycopy( bin,pnt,key,0,keyLen ) ;
        boolean ret = session.mdbm().containsKey( key ) ;
        key = null ;
        returnBool( session,ret ) ;
    }
    
    /**
     * データSize実行.
     */
    private static final void resulSize( DbmSession session ) throws Exception {
        out( "size" ) ;
        int ret = session.mdbm().size() ;
        returnSize( session,ret ) ;
    }
    
    /**
     * データDirectory実行.
     */
    private static final void resultDirectory( DbmSession session ) throws Exception {
        out( "directory" ) ;
        String ret = session.mdbm().getDirectory() ;
        if( ret == null || ret.length() <= 0 ) {
            returnData( session,null ) ;
        }
        else {
            returnData( session,ret.getBytes( "UTF8" ) ) ;
        }
    }
    
    /**
     * Key一覧初期化実行.
     */
    private static final void resulInitKey( DbmSession session ) throws Exception {
        out( "initKey" ) ;
        session.clearKeys() ;
        returnSuccess( session ) ;
    }
    
    /**
     * Key一覧確認実行.
     */
    private static final void resulHasKey( DbmSession session ) throws Exception {
        out( "hasKey" ) ;
        Enumeration<byte[]> keys = session.getKeys() ;
        if( keys == null ) {
            keys = session.mdbm().elements() ;
            session.setKeys( keys ) ;
        }
        boolean ret = keys.hasMoreElements() ;
        returnBool( session,ret ) ;
    }
    
    /**
     * Key一覧確認実行.
     */
    private static final void resulGetKey( DbmSession session ) throws Exception {
        out( "getKey" ) ;
        Enumeration<byte[]> keys = session.getKeys() ;
        if( keys == null ) {
            keys = session.mdbm().elements() ;
            session.setKeys( keys ) ;
        }
        byte[] ret = keys.nextElement() ;
        returnData( session,ret ) ;
    }
    
    /**
     * シーケンスID実行.
     */
    private static final void resultSequenceId( byte[] bin,DbmSession session ) throws Exception {
        out( "sequenceId" ) ;
        int no = ConvertParam.convertInt( ProtocolDef.SEND_OFFSET,bin ) ;
        long ret = session.mdbm().sequenceId( no ) ;
        returnId( session,ret ) ;
    }
    
    /**
     * 正常結果を返す.
     */
    private static final void returnSuccess( DbmSession session ) throws Exception {
        out( "return success" ) ;
        OutputStream o = session.outputStream() ;
        synchronized( o ) {
            o.write( ConvertParam.convertInt( 8 ) ) ;
            o.write( ConvertParam.convertInt( ProtocolDef.RESULT_SUCCESS ) ) ;
            o.flush() ;
        }
    }
    
    /**
     * 異常結果を返す.
     */
    private static final void returnError( DbmSession session,String message ) throws Exception {
        out( "return error" ) ;
        if( message == null || ( message = message.trim() ).length() <= 0 ) {
            message = "error" ;
        }
        OutputStream o = session.outputStream() ;
        synchronized( o ) {
            byte[] b = message.getBytes( "UTF8" ) ;
            o.write( ConvertParam.convertInt( 12 + b.length ) ) ;
            o.write( ConvertParam.convertInt( ProtocolDef.RESULT_ERROR ) ) ;
            o.write( ConvertParam.convertInt( b.length ) ) ;
            o.write( b ) ;
            o.flush() ;
        }
    }
    
    /**
     * 存在確認結果を返す.
     */
    private static final void returnBool( DbmSession session,boolean bool ) throws Exception {
        out( "return bool" ) ;
        OutputStream o = session.outputStream() ;
        synchronized( o ) {
            o.write( ConvertParam.convertInt( 9 ) ) ;
            o.write( ConvertParam.convertInt( ProtocolDef.RESULT_BOOL ) ) ;
            o.write( ConvertParam.convertBoolean( bool ) ) ;
            o.flush() ;
        }
    }
    
    /**
     * データ取得結果を返す.
     */
    private static final void returnData( DbmSession session,byte[] data ) throws Exception {
        out( "return data" ) ;
        int len = 0 ;
        if( data != null ) {
            len = data.length ;
        }
        OutputStream o = session.outputStream() ;
        synchronized( o ) {
            o.write( ConvertParam.convertInt( 12 + len ) ) ;
            o.write( ConvertParam.convertInt( ProtocolDef.RESULT_DATA ) ) ;
            o.write( ConvertParam.convertInt( len ) ) ;
            if( len > 0 ) {
                o.write( data ) ;
            }
            o.flush() ;
        }
    }
    
    /**
     * データ取得結果を返す.
     */
    private static final void returnSize( DbmSession session,int size ) throws Exception {
        out( "return size" ) ;
        OutputStream o = session.outputStream() ;
        synchronized( o ) {
            o.write( ConvertParam.convertInt( 12 ) ) ;
            o.write( ConvertParam.convertInt( ProtocolDef.RESULT_SIZE ) ) ;
            o.write( ConvertParam.convertInt( size ) ) ;
            o.flush() ;
        }
    }
    
    /**
     * ID取得結果を返す.
     */
    private static final void returnId( DbmSession session,long id ) throws Exception {
        out( "return size" ) ;
        OutputStream o = session.outputStream() ;
        synchronized( o ) {
            o.write( ConvertParam.convertInt( 16 ) ) ;
            o.write( ConvertParam.convertInt( ProtocolDef.RESULT_ID ) ) ;
            o.write( ConvertParam.convertLong( id ) ) ;
            o.flush() ;
        }
    }
    
    private static final void out( String msg ) {
        //System.out.println( ">" + msg ) ;
    }
}
