package org.maachang.dbm.service ;

/**
 * プロトコル定義.
 * 
 * @version 2008/01/18
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
public class ProtocolDef {
    
    private ProtocolDef() {}
    
    /**
     * 接続先ポート番号.
     */
    public static final int BIND_PORT = 9801 ;
    
    /**
     * シャットダウンポート番号.
     */
    public static final int SHUTDOWN_PORT = 9821 ;
    
    /**
     * プロトコルオフセット値.
     */
    public static final int OFFSET = 4 ;
    
    /**
     * 命令オフセット値.
     */
    public static final int SEND_OFFSET = OFFSET + 4 ;
    
    /**
     * 命令処理 : クローズ.
     */
    public static final int SEND_CLOSE = 0x00000001 ;
    
    /**
     * 命令処理 : コミット.
     */
    public static final int SEND_COMMIT = 0x00000002 ;
    
    /**
     * 命令処理 : ロールバック.
     */
    public static final int SEND_ROLLBACK = 0x00000003 ;
    
    /**
     * 命令処理 : トランザクション確認.
     */
    public static final int SEND_TRANSACTOIN = 0x00000004 ;
    
    /**
     * 命令処理 : データセット.
     */
    public static final int SEND_PUT = 0x00000011 ;
    
    /**
     * 命令処理 : データ削除.
     */
    public static final int SEND_REMOVE = 0x00000012 ;
    
    /**
     * 命令処理 : データ取得.
     */
    public static final int SEND_GET = 0x00000013 ;
    
    /**
     * 命令処理 : キー確認.
     */
    public static final int SEND_CONTAINS = 0x00000014 ;
    
    /**
     * 命令処理 : サイズ取得.
     */
    public static final int SEND_SIZE = 0x00000101 ;
    
    /**
     * 命令処理 : ディレクトリ取得.
     */
    public static final int SEND_DIRECTORY = 0x00000102 ;
    
    /**
     * 命令処理 : Key一覧初期化.
     */
    public static final int SEND_INIT_KEY = 0x00000103 ;
    
    /**
     * 命令処理 : Key一覧確認.
     */
    public static final int SEND_HAS_KEY = 0x00000104 ;
    
    /**
     * 命令処理 : Key一覧取得.
     */
    public static final int SEND_GET_KEY = 0x00000105 ;
    
    /**
     * 命令処理 : シーケンスID取得.
     */
    public static final int SEND_SEQUENCE_ID = 0x00000201 ;
    
    /**
     * 戻り値 : 正常終了.
     */
    public static final int RESULT_SUCCESS = 0x00000001 ;
    
    /**
     * 戻り値 : 異常終了.
     */
    public static final int RESULT_ERROR = 0x00000002 ;
    
    /**
     * 戻り値 : 存在確認.
     */
    public static final int RESULT_BOOL = 0x00000010 ;
    
    /**
     * 戻り値 : データ取得.
     */
    public static final int RESULT_DATA = 0x00000011 ;
    
    /**
     * 戻り値 : サイズ取得.
     */
    public static final int RESULT_SIZE = 0x00000012 ;
    
    /**
     * 戻り値 : ID取得.
     */
    public static final int RESULT_ID = 0x00000013 ;
    
}
