package org.maachang.dbm.service.client ;

import java.util.ArrayList;

/**
 * Clientコネクション管理.
 * 
 * @version 2008/01/20
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class ClientConnectManager {
    
    /**
     * コネクション管理.
     */
    private ArrayList<ClientSession> conns = null ;
    
    /**
     * コンストラクタ.
     */
    public ClientConnectManager() {
        conns = new ArrayList<ClientSession>() ;
    }
    
    protected void finalize() throws Exception {
        this.destroy() ;
    }
    
    public synchronized void destroy() {
        if( conns != null ) {
            conns.clear() ;
        }
        conns = null ;
    }
    
    public synchronized void put( ClientSession session ) {
        if( conns == null ) {
            return ;
        }
        if( session != null && session.isUse() == true ) {
            conns.add( session ) ;
        }
    }
    
    public synchronized void remove( int no ) {
        if( conns == null || no < 0 || no > conns.size() ) {
            return ;
        }
        conns.remove( no ) ;
    }
    
    public synchronized ClientSession get( int no ) {
        if( conns == null || no < 0 || no > conns.size() ) {
            return null ;
        }
        return conns.get( no ) ;
    }
    
    public synchronized int size() {
        if( conns != null ) {
            return conns.size() ;
        }
        return -1 ;
    }
    
    public synchronized boolean isUse() {
        return conns != null ;
    }
}
