package org.maachang.dbm.service.client ;

import java.util.Enumeration;

/**
 * MDbmConnection次情報管理用.
 * 
 * @version 2008/01/20
 * @author masahito suzuki
 * @since MaachangDBM 1.03
 */
class MDbmEnumConnection implements Enumeration<byte[]> {
    
    private MDbmClientConnection conn = null ;
    
    private MDbmEnumConnection() {
        
    }
    
    public MDbmEnumConnection( MDbmClientConnection conn )
        throws Exception {
        if( conn == null || conn.isUse() == false ) {
            throw new IllegalArgumentException( "コネクション接続が確立していません" ) ;
        }
        conn.initKey() ;
        this.conn = conn ;
    }
    
    protected void finalize() throws Exception {
        conn = null ;
    }
    
    public boolean hasMoreElements() {
        if( conn == null || conn.isUse() == false ) {
            return false ;
        }
        boolean ret = false ;
        try {
	        ret = conn.hasKey() ;
        } catch( Exception e ) {
        	ret = false ;
        }
        return ret ;
    }
    
    public byte[] nextElement() {
        if( conn == null || conn.isUse() == false ) {
            return null ;
        }
        byte[] ret = null ;
        try {
        	ret = conn.getKey() ;
        } catch( Exception e ) {
        	ret = null ;
        }
        return ret ;
    }
}
