/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.proxy.ProxyShutdown;
import org.maachang.proxy.down.ShutdownHook;
import org.maachang.proxy.down.WaitShutdown;
import org.maachang.proxy.engine.EngineService;
import org.maachang.proxy.engine.VersionDef;
import org.maachang.proxy.engine.error.ErrorPageManager;
import org.maachang.util.FileUtil;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

public class MaachangProxy {
    private static final String CONF = "conf/";
    private static final String SERVER_CONF = "conf/server.conf";
    private static final String SSL_CONF = "conf/ssl.conf";
    private static final Log LOG = LogFactory.getLog(MaachangProxy.class);

    public static final void main(String[] args) throws Exception {
        new MaachangProxy().execution(args);
    }

    private final void execution(String[] args) throws Exception {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("** startup MaachangProxy[" + VersionDef.getVersion() + "] **"));
        }
        MaachangProxy.initErrorPage();
        Config serverConfig = MaachangProxy.getConfig(SERVER_CONF);
        EngineService service = new EngineService(serverConfig, MaachangProxy.getConfig(SSL_CONF));
        ShutdownHook hook = ShutdownHook.registHook(new ProxyShutdown(service));
        WaitShutdown waitDown = new WaitShutdown(MaachangProxy.getShutdownPort(serverConfig));
        while (service.isUse() && !waitDown.isShutdown()) {
        }
        hook.getShutdownCallback().execution();
        waitDown.exitShutdown();
    }

    protected static final Config getConfig(String name) throws Exception {
        BufferedReader r = null;
        try {
            Config ret = new Config();
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));
            ReadIni.analisys(ret, r);
            r.close();
            r = null;
            Config config = ret;
            return config;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final void initErrorPage() throws Exception {
        String dir = FileUtil.getFullPath(".");
        ErrorPageManager man = ErrorPageManager.getInstance();
        man.create(dir);
    }

    protected static final int getShutdownPort(Config conf) throws Exception {
        if (conf == null) {
            conf = MaachangProxy.getConfig(SERVER_CONF);
        }
        return conf.getInt("server", "shutdown-port", 0);
    }
}

