/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine;

import java.net.InetAddress;
import org.maachang.proxy.engine.ProxyReceiveCallback;
import org.maachang.proxy.engine.conf.AccessManager;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.proxy.engine.conf.SerializableObject;
import org.maachang.proxy.engine.conf.ServerOption;
import org.maachang.proxy.engine.conf.SslOption;
import org.maachang.proxy.engine.net.http.NetService;
import org.maachang.proxy.engine.net.server.ProxyManager;
import org.maachang.util.conf.Config;

public class EngineService {
    private NetService netService = null;
    private ProxyManager proxyManager = null;
    private RefusalAddressManager refusal = null;
    private AccessManager accessManager = null;

    public EngineService() {
    }

    public EngineService(Config serverConf, Config sslConf) throws Exception {
        this.open(serverConf, sslConf);
    }

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(Config serverConf, Config sslConf) throws Exception {
        try {
            if (serverConf == null || sslConf == null) {
                throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
            }
            ServerOption serverOpt = ServerOption.create(serverConf);
            SslOption sslOpt = SslOption.create(serverConf);
            this.proxyManager = SerializableObject.getInstance().decodeSerializeByProxy();
            this.refusal = SerializableObject.getInstance().decodeSerializeByRefusalAddress();
            this.accessManager = SerializableObject.getInstance().decodeSerializeByAccess();
            this.netService = new NetService();
            if (serverOpt.getBindAddress() == null) {
                this.netService.open(new ProxyReceiveCallback(this.proxyManager, this.refusal, this.accessManager), sslOpt, serverOpt.getConnectLength(), serverOpt.getPoolLength(), serverOpt.getPort());
            } else {
                this.netService.open(new ProxyReceiveCallback(this.proxyManager, this.refusal, this.accessManager), sslOpt, serverOpt.getConnectLength(), serverOpt.getPoolLength(), InetAddress.getByName(serverOpt.getBindAddress()), serverOpt.getPort());
            }
        }
        catch (Exception e) {
            this.close();
            throw e;
        }
    }

    public void close() {
        if (this.accessManager != null) {
            try {
                SerializableObject.getInstance().encodeSerializableByAccess(this.accessManager);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.netService != null) {
            this.netService.close();
        }
        this.netService = null;
        this.proxyManager = null;
    }

    public boolean isUse() {
        return this.proxyManager.isUse();
    }
}

