/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine;

import java.io.BufferedOutputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.proxy.engine.ReceiveAnalysisDefine;
import org.maachang.proxy.engine.StateException;
import org.maachang.proxy.engine.VersionDef;
import org.maachang.proxy.engine.admin.AdminException;
import org.maachang.proxy.engine.admin.AdminManager;
import org.maachang.proxy.engine.conf.AccessManager;
import org.maachang.proxy.engine.conf.MaachangProxyConfig;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.proxy.engine.error.ErrorDef;
import org.maachang.proxy.engine.error.ErrorPageManager;
import org.maachang.proxy.engine.mobile.ConvertMobile;
import org.maachang.proxy.engine.mobile.MobileInfo;
import org.maachang.proxy.engine.mobile.carrier.CarrierConfig;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.proxy.engine.mobile.emoji.ConvertEmoji;
import org.maachang.proxy.engine.mobile.emoji.EmojiConfig;
import org.maachang.proxy.engine.mobile.emoji.image.EmojiImageCache;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.http.Cookie;
import org.maachang.proxy.engine.net.http.HttpCallbackReceive;
import org.maachang.proxy.engine.net.http.HttpdTimestamp;
import org.maachang.proxy.engine.net.server.ExpireServerConnectException;
import org.maachang.proxy.engine.net.server.HttpConnector;
import org.maachang.proxy.engine.net.server.HttpPoolingConnector;
import org.maachang.proxy.engine.net.server.ProxyInfo;
import org.maachang.proxy.engine.net.server.ProxyManager;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.CharsetMask;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

class ProxyReceiveCallback
implements HttpCallbackReceive {
    private static final Log LOG = LogFactory.getLog(ProxyReceiveCallback.class);
    private static final long WAIT_TIME = 15L;
    private ProxyManager manager = null;
    private RefusalAddressManager refusal = null;
    private MaachangProxyConfig maachangProxyConfig = null;
    private AccessManager accessManager = null;
    private AdminManager admin = null;
    private CarrierConfig carrierConfig = null;
    private EmojiConfig emojiConfig = null;

    private ProxyReceiveCallback() {
    }

    public ProxyReceiveCallback(ProxyManager manager, RefusalAddressManager refusal, AccessManager accessManager) throws Exception {
        if (manager == null || !manager.isUse()) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.manager = manager;
        this.refusal = refusal;
        this.accessManager = accessManager;
        this.admin = new AdminManager();
        this.carrierConfig = new CarrierConfig();
        this.emojiConfig = new EmojiConfig();
        this.maachangProxyConfig = new MaachangProxyConfig();
    }

    public void execution(ConnectionInfo conn, int seqId, RequestInfo request) throws Exception {
        String host = request.getHeader("Host", 0);
        String url = request.getUrl();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("## access-hostName(" + seqId + "):" + host + url));
        }
        InetAddress connectAddress = conn.getSocket().socket().getInetAddress();
        String userAgent = request.getHeader("User-Agent", 0);
        ProxyReceiveCallback.smartRequest(request);
        MobileInfo mobileInfo = this.getMobileInfo(request, seqId);
        if (this.adminAccess(request, conn, seqId, mobileInfo, host, url)) {
            return;
        }
        if (this.refusal.isRefusal(connectAddress)) {
            LOG.warn((Object)("\u62d2\u5426\u30a2\u30c9\u30ec\u30b9\u304b\u3089\u306e\u30a2\u30af\u30bb\u30b9\u3092\u691c\u77e5[" + connectAddress.getHostAddress() + "]"));
            conn.setCloseFlag(true);
            return;
        }
        if (userAgent == null || (userAgent = userAgent.trim()).length() <= 0) {
            LOG.warn((Object)("\u30e6\u30fc\u30b6\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u306a\u3057\u306e\u30a2\u30af\u30bb\u30b9\u3092\u691c\u77e5[" + connectAddress.getHostAddress() + "]"));
            conn.setCloseFlag(true);
            return;
        }
        if (this.errorPageToIncludeData(request, conn, mobileInfo, host, url)) {
            return;
        }
        if (this.emojiImageData(request, conn, mobileInfo, host, url)) {
            return;
        }
        ProxyInfo info = this.manager.get(request);
        if (info == null) {
            ProxyReceiveCallback.sendErrorMessage(new StateException(host, 404, "\u6307\u5b9aHost[" + host + "]\u306f\u5b58\u5728\u3057\u307e\u305b\u3093"), conn, String.valueOf(host) + url, mobileInfo);
            return;
        }
        if (this.noAccessClient(info, mobileInfo.getMobileData())) {
            LOG.warn((Object)("\u62d2\u5426\u30e6\u30fc\u30b6\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8\u306e\u30a2\u30af\u30bb\u30b9\u3092\u691c\u77e5[" + userAgent + "]"));
            conn.setCloseFlag(true);
            return;
        }
        request.putHeader("X-Sequence-Id", String.valueOf(seqId));
        ConvertEmoji.convertRequestBody(request, mobileInfo.getEmojiConfig(), mobileInfo.getMobileData());
        Cookie.getSessionId(info, request);
        HttpPoolingConnector pool = null;
        HttpConnector connector = null;
        try {
            pool = info.getHttpPoolingConnector();
            this.changeConnectionHostName(request, info);
            if (mobileInfo.getMobileData() != null) {
                this.convertGetPostDataByCharset(request, info, mobileInfo.getMobileData(), mobileInfo.getEmojiConfig());
            }
            while (true) {
                connector = pool.getConnector(conn);
                try {
                    this.sendReceive(request, conn, info, pool, connector, mobileInfo, connectAddress, host);
                }
                catch (ExpireServerConnectException ee) {
                    try {
                        connector.destroy();
                    }
                    catch (Exception exception) {}
                    continue;
                }
                break;
            }
        }
        catch (AdminException ae) {
            ProxyReceiveCallback.sendErrorMessage(ae, conn, String.valueOf(host) + url, mobileInfo);
        }
        catch (StateException se) {
            ProxyReceiveCallback.sendErrorMessage(se, conn, String.valueOf(host) + url, mobileInfo);
        }
        catch (Exception e) {
            LOG.error((Object)"## error", (Throwable)e);
            ProxyReceiveCallback.sendErrorMessage(e, conn, String.valueOf(host) + url, mobileInfo);
        }
    }

    private static final void smartRequest(RequestInfo req) {
        if (req.getHeader("Transfer-Encoding", 0) != null) {
            if (req.getBody() != null) {
                req.putHeader("Content-Length", String.valueOf(req.getBody().length));
            }
            req.removeHeader("Transfer-Encoding");
        }
    }

    private MobileInfo getMobileInfo(RequestInfo request, long seqId) throws Exception {
        String userAgent = request.getHeader("User-Agent", 0);
        MobileData mobileData = this.carrierConfig.getAgent(userAgent);
        if (mobileData == null) {
            request.putHeader("X-Mobile-Carrier", "pc");
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("access-client(" + seqId + "):pc"));
            }
        } else {
            request.putHeader("X-Mobile-Carrier", mobileData.getCarrier());
            request.putHeader("X-Moblie-Code", mobileData.getCode());
            request.putHeader("X-Moblie-Type", mobileData.getType());
            request.putHeader("X-Mobile-X", String.valueOf(mobileData.getX()));
            request.putHeader("X-Mobile-Y", String.valueOf(mobileData.getY()));
            request.putHeader("X-Mobile-Jpeg", String.valueOf(mobileData.isJpegFlag()));
            request.putHeader("X-Mobile-Gif", String.valueOf(mobileData.isGifFlag()));
            request.putHeader("X-Mobile-Png", String.valueOf(mobileData.isPngFlag()));
            request.putHeader("X-Mobile-Flash", String.valueOf(mobileData.isFlashFlag()));
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("access-client(" + seqId + "):mobile[" + mobileData + "]"));
            }
        }
        return new MobileInfo(request, this.emojiConfig, mobileData);
    }

    private boolean adminAccess(RequestInfo request, ConnectionInfo conn, int seqId, MobileInfo mobileInfo, String host, String url) throws Exception {
        InetAddress connAddr = conn.getSocket().socket().getInetAddress();
        if (this.maachangProxyConfig.isAdminUrl(host, request.getUrl()) && this.maachangProxyConfig.isAdmin(connAddr)) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("\u7ba1\u7406\u8005\u753b\u9762[" + request.getUrl() + "]\u306b\u30a2\u30af\u30bb\u30b9\u3092\u691c\u77e5[" + connAddr.getHostAddress() + "]"));
            }
            try {
                this.admin.execution(this.maachangProxyConfig, this.manager, this.refusal, this.accessManager, conn, seqId, request);
            }
            catch (Exception e) {
                LOG.error((Object)"admin-error", (Throwable)e);
                ProxyReceiveCallback.sendErrorMessage(e, conn, String.valueOf(host) + url, mobileInfo);
            }
            return true;
        }
        return false;
    }

    private boolean errorPageToIncludeData(RequestInfo request, ConnectionInfo conn, MobileInfo mobileInfo, String host, String url) throws Exception {
        if (request.getUrl().startsWith("/@error")) {
            try {
                String errImgUrl = AnalysisUtil.cutGetParam(request.getUrl());
                errImgUrl = "/error" + errImgUrl.substring("/@error".length());
                errImgUrl = StringUtil.changeString(errImgUrl, "..", "");
                errImgUrl = "." + errImgUrl;
                byte[] bin = FileUtil.getFile(errImgUrl);
                ResponseInfo response = new ResponseInfo();
                response.setBody(bin);
                response.setState("200");
                response.setVersion("1.1");
                response.addHeader("Content-Type", ErrorDef.getMimeType(request.getUrl()));
                if (response.getBody() != null) {
                    ConvertMobile.convert(response, mobileInfo);
                }
                ProxyReceiveCallback.settingResponse(response, conn, request);
            }
            catch (Exception e2) {
                StateException e2 = new StateException(host, 404, "\u6307\u5b9a\u753b\u50cf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093:" + request.getUrl());
                ProxyReceiveCallback.sendErrorMessage(e2, conn, String.valueOf(host) + url, mobileInfo);
            }
            return true;
        }
        return false;
    }

    private boolean emojiImageData(RequestInfo request, ConnectionInfo conn, MobileInfo mobileInfo, String host, String url) throws Exception {
        if (request.getUrl().startsWith("/@emoji/")) {
            try {
                String emojiImgUrl = AnalysisUtil.cutGetParam(request.getUrl());
                emojiImgUrl = emojiImgUrl.substring("/@emoji/".length());
                if (!this.emojiImage(emojiImgUrl)) {
                    throw new Exception();
                }
                byte[] bin = EmojiImageCache.getInstance().getImage(emojiImgUrl);
                ResponseInfo response = new ResponseInfo();
                response.setBody(bin);
                response.setState("200");
                response.setVersion("1.1");
                response.addHeader("Content-Type", "image/gif");
                ProxyReceiveCallback.settingResponse(response, conn, request);
            }
            catch (Exception e2) {
                StateException e2 = new StateException(host, 404, "\u6307\u5b9a\u7d75\u6587\u5b57\u306f\u5b58\u5728\u3057\u307e\u305b\u3093:" + request.getUrl());
                ProxyReceiveCallback.sendErrorMessage(e2, conn, String.valueOf(host) + url, mobileInfo);
            }
            return true;
        }
        return false;
    }

    private boolean noAccessClient(ProxyInfo info, MobileData mobileData) {
        if (!info.isAccessMobileFlag() && mobileData != null) {
            return true;
        }
        return !info.isAccessPcFlag() && mobileData == null;
    }

    private void changeConnectionHostName(RequestInfo request, ProxyInfo info) throws Exception {
        if (info.getPort() == 80) {
            request.putHeader("Host", info.getDestUrl());
        } else {
            request.putHeader("Host", info.getDestUrl() + ":" + info.getPort());
        }
    }

    private void exitServerConnector(RequestInfo request, HttpPoolingConnector pool, HttpConnector connector) throws Exception {
        if (connector.isLocal() || "close".equals(request.getHeader("Connection", 0))) {
            if (connector != null) {
                connector.destroy();
            }
        } else {
            pool.releaseConnector(connector);
        }
    }

    private static final void settingResponse(ResponseInfo res, ConnectionInfo conn, RequestInfo req) throws Exception {
        boolean closeFlag = true;
        String connectionMode = req.getHeader("Connection", 0);
        if (connectionMode != null && (connectionMode = connectionMode.trim()).length() > 0 && "keep-alive".equals(connectionMode)) {
            closeFlag = false;
        }
        res.removeHeader("Keep-Alive");
        res.removeHeader("Connection");
        res.removeHeader("Transfer-Encoding");
        res.removeHeader("Content-Length");
        if (closeFlag) {
            res.putHeader("Connection", "close");
            conn.setCloseFlag(true);
        } else {
            res.putHeader("Keep-Alive", "timeout=" + conn.getTimeout() / 1000L);
            res.addHeader("Keep-Alive", "max=" + conn.getCount());
            res.putHeader("Connection", "keep-alive");
        }
        if (res.getBody() == null) {
            res.putHeader("Content-Length", "0");
        } else {
            res.putHeader("Content-Length", String.valueOf(res.getBody().length));
        }
        if (res.getHeader("Server", 0) == null) {
            res.putHeader("Server", VersionDef.getServerName());
        } else {
            res.putHeader("Server", res.getHeader("Server", 0) + "@(" + VersionDef.getServerName() + ")");
        }
        res.putHeader("Expires", HttpdTimestamp.getTimestamp(0L));
        res.putHeader("Pragma", "no-cache");
        res.putHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
        res.putHeader("Cache-Control", "private");
        res.addHeader("Cache-Control", "no-cache");
        res.addHeader("Cache-Control", "no-store");
        res.addHeader("Cache-Control", "max-age=0");
        try {
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(res.responseByBinary());
        }
        catch (Exception e) {
            try {
                conn.setCloseFlag(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void settingHeader(ResponseInfo res, ConnectionInfo conn, RequestInfo req) throws Exception {
        boolean closeFlag = true;
        String connectionMode = req.getHeader("Connection", 0);
        if (connectionMode != null && (connectionMode = connectionMode.trim()).length() > 0 && "keep-alive".equals(connectionMode)) {
            closeFlag = false;
        }
        res.removeHeader("Keep-Alive");
        res.removeHeader("Connection");
        if (closeFlag) {
            res.putHeader("Connection", "close");
            conn.setCloseFlag(true);
        } else {
            res.putHeader("Keep-Alive", "timeout=" + conn.getTimeout() / 1000L);
            res.addHeader("Keep-Alive", "max=" + conn.getCount());
            res.putHeader("Connection", "keep-alive");
        }
        if (res.getHeader("Server", 0) == null) {
            res.putHeader("Server", VersionDef.getServerName());
        } else {
            res.putHeader("Server", res.getHeader("Server", 0) + "@(" + VersionDef.getServerName() + ")");
        }
        res.putHeader("Expires", HttpdTimestamp.getTimestamp(0L));
        res.putHeader("Pragma", "no-cache");
        res.putHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
        res.putHeader("Cache-Control", "private");
        res.addHeader("Cache-Control", "no-cache");
        res.addHeader("Cache-Control", "no-store");
        res.addHeader("Cache-Control", "max-age=0");
    }

    private static final void sendErrorMessage(Exception e, ConnectionInfo conn, String host, MobileInfo info) {
        if (conn != null) {
            String message = null;
            int state = 500;
            if (e instanceof StateException) {
                StateException es = (StateException)e;
                message = es.getErrorMessage();
                state = es.getState();
                host = es.getHost();
                LOG.warn((Object)("host:" + host + " state:" + state + " message:" + message));
            } else {
                message = e.getMessage();
            }
            try {
                ResponseInfo res = ErrorPageManager.getInstance().getErrorResponse(info, host, state, null, message);
                if (res.getBody() != null) {
                    ConvertMobile.convert(res, info);
                }
                OutputStream outputStream = conn.getOutputStream();
                outputStream.write(res.responseByBinary());
            }
            catch (Exception ee) {
                try {
                    conn.setCloseFlag(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private boolean emojiImage(String url) {
        if (url == null || url.length() <= 0) {
            return false;
        }
        int len = url.length();
        int i = 0;
        while (i < len) {
            char c = url.charAt(i);
            if (c < '0' || c > '9') {
                return false;
            }
            ++i;
        }
        return true;
    }

    private void convertGetPostDataByCharset(RequestInfo request, ProxyInfo info, MobileData mobileData, EmojiConfig emojiConfig) throws Exception {
        int p;
        if ("POST".equals(request.getMethod()) && request.getBody() != null && request.getBody().length > 0) {
            String bstr = this.convertDataByCharset(request, info, mobileData, emojiConfig, new String(request.getBody(), "ISO-8859-1"));
            request.setBody(bstr.getBytes(info.getCharset()));
            bstr = null;
        }
        if ((p = request.getUrl().indexOf("?")) >= 0) {
            String url = request.getUrl();
            String query = url.substring(p + 1);
            query = this.convertDataByCharset(request, info, mobileData, emojiConfig, query);
            request.setUrl(String.valueOf(url.substring(0, p + 1)) + query);
        }
    }

    private String convertDataByCharset(RequestInfo request, ProxyInfo info, MobileData mobileData, EmojiConfig emojiConfig, String data) throws Exception {
        String reqCharset = info.getCharset();
        if (request.getCharset() == null) {
            if (mobileData.getCarrier().startsWith("softbank")) {
                reqCharset = emojiConfig.getCharset(emojiConfig.getCarrierName(mobileData));
                if ("Windows-31J".equals(reqCharset)) {
                    reqCharset = "SHIFT_JIS";
                }
            } else {
                reqCharset = "SHIFT_JIS";
            }
            request.setCharset(reqCharset);
        } else if (!this.isCharset(request.getCharset(), info.getCharset())) {
            reqCharset = request.getCharset();
        }
        if (this.isCharset(reqCharset, info.getCharset())) {
            return data;
        }
        String src = CharsetMask.getCharset(reqCharset);
        String dest = CharsetMask.getCharset(info.getCharset());
        if (src == null || dest == null) {
            return data;
        }
        return AnalysisUtil.convertBodyByCharset(data, src, dest);
    }

    private boolean isCharset(String src, String dest) {
        src = CharsetMask.getCharset(src);
        dest = CharsetMask.getCharset(dest);
        if (src == null || dest == null) {
            return false;
        }
        return src.equals(dest);
    }

    private void sendReceive(RequestInfo request, ConnectionInfo conn, ProxyInfo info, HttpPoolingConnector pool, HttpConnector connector, MobileInfo mobileInfo, InetAddress connectAddress, String host) throws Exception {
        connector.send(request);
        ResponseInfo response = null;
        int responseCont = 0;
        while (true) {
            if (!pool.checkConnect(connector)) {
                throw new ExpireServerConnectException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u304c\u5207\u65ad\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            response = connector.receive(null, null);
            if (response != null) break;
            if (!pool.checkConnect(connector)) {
                throw new ExpireServerConnectException("\u30b3\u30cd\u30af\u30b7\u30e7\u30f3\u304c\u5207\u65ad\u3055\u308c\u3066\u3044\u307e\u3059");
            }
            Thread.sleep(15L);
            ++responseCont;
        }
        if (response.getState() == null || response.getVersion() == null || response.headerSize() == 0) {
            throw new StateException(host, 500, "\u6307\u5b9aHost\u306f\u30a8\u30e9\u30fc\u306e\u305f\u3081\u5207\u65ad\u3055\u308c\u307e\u3057\u305f:" + host);
        }
        if (!info.isAccessMobileFlag() || !ReceiveAnalysisDefine.isAnalysis(response.getHeader("Content-Type", 0))) {
            block10: {
                BufferedOutputStream outputStream = null;
                try {
                    this.settingHeader(response, conn, request);
                    outputStream = new BufferedOutputStream(conn.getOutputStream());
                    ((OutputStream)outputStream).write(response.responseByBinary(false));
                    connector.receive(outputStream, response);
                    ((OutputStream)outputStream).flush();
                    this.exitServerConnector(request, pool, connector);
                    connector = null;
                }
                catch (Exception e) {
                    try {
                        conn.setCloseFlag(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (connector == null) break block10;
                    connector.destroy();
                }
            }
            this.accessManager.add(host, connectAddress.getHostAddress(), request, response);
            return;
        }
        response = connector.receive(null, response);
        this.exitServerConnector(request, pool, connector);
        connector = null;
        if (response.getBody() != null) {
            ConvertMobile.convert(response, mobileInfo);
        }
        ErrorPageManager.getInstance().proxyErrorResponse(response, request, mobileInfo);
        ProxyReceiveCallback.settingResponse(response, conn, request);
        this.accessManager.add(host, connectAddress.getHostAddress(), request, response);
    }
}

