/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.admin;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.proxy.engine.VersionDef;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.admin.AdminException;
import org.maachang.proxy.engine.error.ErrorDef;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.HttpdTimestamp;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

public abstract class AbstractAdminPage {
    protected static final Log LOG = LogFactory.getLog(AbstractAdminPage.class);
    private static final String PAGE_DIR = "PAGE_DIR";
    private static final String SESSION = "SESSION";
    private static final String SESSION_KEY = "SESSION_KEY";
    private static final String PLUS = ".view";
    protected String pageInfo = null;
    protected String pageDir = null;

    private AbstractAdminPage() {
    }

    public AbstractAdminPage(String name) throws Exception {
        this(name, null);
    }

    protected AbstractAdminPage(String name, String pageDir) throws Exception {
        if (pageDir == null || !pageDir.startsWith("/@admin/")) {
            if (pageDir == null) {
                pageDir = "/@admin/";
            } else {
                if (pageDir.startsWith("/")) {
                    pageDir = pageDir.substring(1);
                }
                pageDir = "/@admin/" + pageDir;
            }
        }
        if (!pageDir.startsWith("/")) {
            pageDir = "/" + pageDir;
        }
        if (!pageDir.endsWith("/")) {
            pageDir = String.valueOf(pageDir) + "/";
        }
        String packageName = StringUtil.changeString(name, ".", "/");
        try {
            this.pageInfo = FileUtil.getScriptByResource(String.valueOf(packageName) + PLUS, "UTF8");
        }
        catch (Exception e) {
            this.pageInfo = null;
        }
        this.pageDir = pageDir;
    }

    public abstract void execution(AdminConnect var1) throws Exception;

    public void flushResponse(ResponseInfo response, int code) throws AdminException {
        if (response.getVersion() == null) {
            try {
                response.setState(String.valueOf(code));
                response.setStateMessage(ErrorDef.convertErrorMessage(code));
                response.setVersion("1.1");
                response.putHeader("Server", VersionDef.getPrintServerName());
                response.putHeader("Date", HttpdTimestamp.getNowTimestamp());
                response.putHeader("Expires", HttpdTimestamp.getTimestamp(0L));
                response.putHeader("Pragma", "no-cache");
                response.putHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
                response.putHeader("Cache-Control", "private");
                response.addHeader("Cache-Control", "no-cache");
                response.addHeader("Cache-Control", "no-store");
                response.addHeader("Cache-Control", "max-age=0");
                response.putHeader("Connection", "close");
            }
            catch (Exception e) {
                throw new AdminException("\u7ba1\u7406\u753b\u9762\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + e.getMessage());
            }
        }
    }

    public String getPageDir() {
        return this.pageDir;
    }

    public void viewController(AdminConnect conn) throws AdminException {
        if (this.pageInfo == null || this.pageInfo.length() <= 0) {
            return;
        }
        HashMap<String, String> map = conn.getViewParams();
        ResponseInfo response = conn.getResponse();
        try {
            if (map == null) {
                map = new HashMap();
                conn.setViewParams(map);
            }
            if (map.get("errorMessage") == null) {
                map.put("errorMessage", "");
            }
            StringBuilder buf = new StringBuilder();
            int p = 0;
            int b = 0;
            while (true) {
                if ((p = this.pageInfo.indexOf("[%", b)) <= -1) break;
                int x = this.pageInfo.indexOf("%]", p + 1);
                if (x <= -1) {
                    buf.append(this.pageInfo.substring(b, p + 2));
                    b = p + 2;
                    continue;
                }
                String key = this.pageInfo.substring(p + 2, x);
                buf.append(this.pageInfo.substring(b, p));
                if (key != null && (key = key.trim()).length() > 0) {
                    String val = map.get(key);
                    if (val != null && val.length() > 0) {
                        buf.append(val);
                    } else if (PAGE_DIR.equals(key)) {
                        buf.append(this.pageDir);
                    } else if (SESSION.equals(key)) {
                        buf.append(map.get("_admin_session"));
                    } else if (SESSION_KEY.equals(key)) {
                        buf.append("_admin_session");
                    }
                }
                b = x + 2;
            }
            buf.append(this.pageInfo.substring(b));
            String body = buf.toString();
            buf = null;
            byte[] bin = body.getBytes("UTF8");
            body = null;
            response.setBody(bin);
            response.putHeader("Content-Type", "text/html; charset=utf-8");
            response.putHeader("Content-Length", String.valueOf(bin.length));
        }
        catch (Exception e) {
            throw new AdminException("\u30da\u30fc\u30b8[" + this.pageDir + "]\u306e\u751f\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + e.getMessage());
        }
    }

    public void forward(AdminConnect conn) throws Exception {
        this.forward(false, conn, null, null);
    }

    public void forward(AdminConnect conn, String path) throws Exception {
        this.forward(false, conn, path, null);
    }

    public void forward(boolean mode, AdminConnect conn, String path) throws Exception {
        this.forward(mode, conn, path, null);
    }

    public void forward(boolean mode, AdminConnect conn, String path, String key) throws Exception {
        if (mode || !conn.isForwardFlag()) {
            if (key != null && (key = key.trim()).length() > 0) {
                conn.getViewParams().put("_admin_session", key);
                conn.getParams().add("_admin_session", key);
            }
            if (path == null || (path = path.trim()).length() <= 0) {
                this.viewController(conn);
                conn.setForwardFlag(true);
            } else {
                AbstractAdminPage page = conn.getManager().getPage(conn.getConf(), path);
                if (mode) {
                    conn.setForwardFlag(false);
                    page.execution(conn);
                    if (!conn.isForwardFlag()) {
                        page.viewController(conn);
                        conn.setForwardFlag(true);
                    }
                } else {
                    page.viewController(conn);
                    conn.setForwardFlag(true);
                }
            }
        }
    }

    public void redirectAdmin(AdminConnect conn, String url) throws Exception {
        this.redirectAdmin(conn, url, null);
    }

    public void redirectAdmin(AdminConnect conn, String url, String sessionKey) throws Exception {
        if (!url.startsWith("/@admin/")) {
            if (url.startsWith("/")) {
                url = url.substring(1);
            }
            url = "/@admin/" + url;
        }
        this.redirect(conn, url, sessionKey);
    }

    public void redirect(AdminConnect conn, String url) throws Exception {
        this.redirect(conn, url, null);
    }

    public void redirect(AdminConnect conn, String url, String sessionKey) throws Exception {
        if (sessionKey == null) {
            sessionKey = (String)conn.getParams().get("_admin_session");
        }
        if (sessionKey != null && conn.getSession().getSession(sessionKey) != null) {
            url = url.indexOf("?") >= 0 ? String.valueOf(url) + "&_admin_session=" + sessionKey : String.valueOf(url) + "?_admin_session=" + sessionKey;
        }
        this.flushResponse(conn.getResponse(), 303);
        conn.getResponse().putHeader("Location", url);
    }

    public String getSessionId(AdminConnect conn) {
        return (String)conn.getParams().get("_admin_session");
    }

    public String getSessionIdByGetParam(AdminConnect conn) {
        return "_admin_session=" + conn.getParams().get("_admin_session");
    }

    public void addErrorMessage(AdminConnect conn, String message) {
        if (message == null || (message = message.trim()).length() <= 0) {
            return;
        }
        HashMap<String, String> p = conn.getViewParams();
        String bef = p.get("errorMessage");
        bef = bef != null ? String.valueOf(bef) + "<BR>" + message : message;
        p.put("errorMessage", bef);
    }

    public boolean isLogin(AdminConnect conn) throws Exception {
        if (conn.getConf().isAuthAdmin()) {
            String key = (String)conn.getParams().get("_admin_session");
            if (conn.getSession().getSession(key) == null) {
                this.redirectAdmin(conn, "/");
                conn.setForwardFlag(true);
                return true;
            }
        }
        return false;
    }

    public void outputOptions(AdminConnect conn, String name, Object ... options) throws Exception {
        this.outputOptions(conn, name, null, options);
    }

    public void outputOptions(AdminConnect conn, String name, String value, Object ... options) throws Exception {
        if (options == null || options.length <= 0) {
            return;
        }
        StringBuilder buf = new StringBuilder();
        String data = (String)conn.getParams().get(name);
        if (data == null || data.length() <= 0) {
            data = value;
        }
        int len = options.length;
        int i = 0;
        while (i < len) {
            String[] vals = (String[])options[i];
            buf.append("<option value='").append(vals[0]).append("'");
            if (vals[0].equals(data)) {
                buf.append(" selected");
            }
            buf.append(">").append(vals[1]);
            ++i;
        }
        String s = buf.toString();
        buf = null;
        conn.getViewParams().put(name, s);
    }
}

