/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.admin;

import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import org.maachang.proxy.engine.admin.AbstractAdminPage;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.admin.AdminException;
import org.maachang.proxy.engine.admin.AdminSession;
import org.maachang.proxy.engine.conf.AccessManager;
import org.maachang.proxy.engine.conf.MaachangProxyConfig;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.proxy.engine.net.http.MultiPartForm;
import org.maachang.proxy.engine.net.server.ProxyManager;
import org.maachang.util.AnalysisUtil;

public class AdminManager {
    public static final String ADMIN_URL = "/@admin/";
    public static final String SESSION_ID = "_admin_session";
    private HashMap<String, AbstractAdminPage> manager = new HashMap();
    private AdminSession session = new AdminSession();

    public synchronized void execution(MaachangProxyConfig conf, ProxyManager proxyManager, RefusalAddressManager refusal, AccessManager accessManager, ConnectionInfo conn, int seqId, RequestInfo request) throws AdminException {
        try {
            AbstractAdminPage page = this.getPage(conf, request.getUrl());
            ResponseInfo res = new ResponseInfo();
            HashMap<String, String> viewParams = new HashMap<String, String>();
            HttpParams httpParams = MultiPartForm.convertMultiPartForm(request, "UTF8");
            AnalysisUtil.convertAnalysisQuery(httpParams, request, "UTF8");
            String sessionKey = (String)httpParams.get(SESSION_ID);
            if (!this.session.updateSession(sessionKey)) {
                sessionKey = "";
            }
            viewParams.put(SESSION_ID, sessionKey);
            try {
                AdminConnect acn = new AdminConnect(res, conf, proxyManager, refusal, accessManager, this, this.session, request, httpParams, seqId, viewParams);
                page.execution(acn);
                if (!acn.isForwardFlag()) {
                    page.forward(acn);
                }
            }
            catch (AdminException ae) {
                throw ae;
            }
            catch (Exception e) {
                throw new AdminException(String.valueOf(this.getClass().getName()) + "\u306e\u51e6\u7406\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + e.getMessage());
            }
            page.flushResponse(res, 200);
            OutputStream outputStream = conn.getOutputStream();
            outputStream.write(res.responseByBinary());
            outputStream.flush();
            conn.setCloseFlag(true);
        }
        catch (AdminException ae) {
            throw ae;
        }
        catch (Exception e) {
            throw new AdminException("\u6307\u5b9a\u30da\u30fc\u30b8\u540d[" + request.getUrl() + "]\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + e.getMessage());
        }
    }

    public synchronized AbstractAdminPage getPage(MaachangProxyConfig conf, String url) throws AdminException {
        try {
            if (url == null) {
                url = "";
            }
            if (!url.startsWith(ADMIN_URL)) {
                if (url.startsWith("/")) {
                    url = url.substring(1);
                }
                url = ADMIN_URL + url;
            }
            AbstractAdminPage ret = null;
            String packageName = conf.getAdminUrl(url);
            ret = this.manager.get(packageName);
            if (ret == null) {
                Class<?> clazz = Class.forName(packageName);
                Class<AbstractAdminPage> adminClazz = clazz.asSubclass(AbstractAdminPage.class);
                Constructor<AbstractAdminPage> cst = adminClazz.getConstructor(String.class);
                ret = cst.newInstance(packageName);
                this.manager.put(packageName, ret);
            }
            return ret;
        }
        catch (Exception e) {
            throw new AdminException("\u6307\u5b9a\u30da\u30fc\u30b8\u540d[" + url + "]\u306e\u8aad\u307f\u8fbc\u307f\u306b\u5931\u6557\u3057\u307e\u3057\u305f:" + e.getMessage());
        }
    }
}

