/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.admin;

import org.maachang.proxy.engine.admin.AdminSession;

class AdminSessionThread
extends Thread {
    private static final long TIME_OUT = 1800000L;
    private AdminSession session = null;
    private volatile boolean stopFlag = true;

    private AdminSessionThread() {
    }

    public AdminSessionThread(AdminSession session) throws Exception {
        this.session = session;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                Object[] keys = this.session.getKey();
                if (keys != null && keys.length > 0) {
                    int len = keys.length;
                    int i = 0;
                    while (i < len) {
                        Thread.sleep(50L);
                        String key = (String)keys[i];
                        if (key == null) {
                            this.session.removeSession(key);
                        } else {
                            Long data = this.session.getSession(key);
                            if (data == null || data + 1800000L <= System.currentTimeMillis()) {
                                this.session.removeSession(key);
                            }
                        }
                        ++i;
                    }
                }
                Thread.sleep(1000L);
            }
            catch (InterruptedException ite) {
                endFlag = true;
            }
            catch (NullPointerException ite) {
            }
            catch (OutOfMemoryError ite) {
            }
            catch (Exception ite) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.session = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

