/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.admin.page;

import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.conf.AccessInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AdminAccessList
extends AbstractAdminNextLogin {
    public AdminAccessList(String name) throws Exception {
        super(name);
    }

    @Override
    public void nextLogin(AdminConnect conn) throws Exception {
        ArrayList<AccessInfo> lst = conn.getAccessManager().get();
        HashMap<String, String> viewParams = conn.getViewParams();
        viewParams.put("viewCount", String.valueOf(lst.size()));
        viewParams.put("viewList", this.viewAccessList(lst));
    }

    private String viewAccessList(ArrayList<AccessInfo> lst) throws Exception {
        StringBuilder buf = new StringBuilder();
        buf.append("<tr><th>\u9805\u756a</th>");
        buf.append("<th>\u65e5\u4ed8</th>");
        buf.append("<th>state</th>");
        buf.append("<th>URL</th>");
        buf.append("<th>address</th>");
        buf.append("<th>\u30e6\u30fc\u30b6\u30a8\u30fc\u30b8\u30a7\u30f3\u30c8</th>");
        buf.append("</tr>\r\n");
        int len = lst.size();
        int cnt = 1;
        int i = len - 1;
        while (i >= 0) {
            AccessInfo info = lst.get(i);
            buf.append("<tr><td>").append(cnt).append("</td>");
            buf.append("<td>").append(info.getDate()).append("</td>");
            buf.append("<td>").append(info.getState()).append("</td>");
            buf.append("<td>").append(this.cutString(info.getUrl(), 36)).append("</td>");
            buf.append("<td>").append(info.getAddr()).append("</td>");
            buf.append("<td>").append(this.cutString(info.getUserAgent(), 24)).append("</td>");
            buf.append("</tr>\r\n");
            ++cnt;
            --i;
        }
        return buf.toString();
    }

    private String cutString(String code, int len) {
        if (code == null || code.length() <= 0) {
            return "&nbsp;";
        }
        StringBuilder buf = new StringBuilder();
        int b = 0;
        while (true) {
            boolean exitFlag = false;
            String c = null;
            if (code.length() > len + b) {
                c = code.substring(b, b + len);
            } else {
                c = code.substring(b);
                exitFlag = true;
            }
            buf.append(c);
            if (exitFlag) break;
            buf.append("<br>");
            b += len;
        }
        return buf.toString();
    }
}

