/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.admin.page;

import java.util.ArrayList;
import org.maachang.proxy.engine.admin.AbstractAdminNextLogin;
import org.maachang.proxy.engine.admin.AdminConnect;
import org.maachang.proxy.engine.conf.SerializableObject;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.StringUtil;

public class AdminCreateRefusalTo
extends AbstractAdminNextLogin {
    public AdminCreateRefusalTo(String name) throws Exception {
        super(name);
    }

    public void nextLogin(AdminConnect conn) throws Exception {
        HttpParams params = conn.getParams();
        String ipaddr = (String)params.get("ipaddr");
        String ipmask = (String)params.get("ipmask");
        boolean errorFlag = false;
        if (ipaddr == null || (ipaddr = ipaddr.trim()).length() <= 0 || ipmask == null || (ipmask = ipmask.trim()).length() <= 0) {
            if (ipaddr == null || ipaddr.length() <= 0) {
                this.addErrorMessage(conn, "IP\u30a2\u30c9\u30ec\u30b9\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                ipaddr = "";
                errorFlag = true;
            }
            if (ipmask == null || ipmask.length() <= 0) {
                this.addErrorMessage(conn, "IP\u30de\u30b9\u30af\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
                ipmask = "";
                errorFlag = true;
            }
        } else {
            if (!this.isIpAddress(ipaddr)) {
                this.addErrorMessage(conn, "IP\u30a2\u30c9\u30ec\u30b9\u306e\u30d5\u30a9\u30fc\u30de\u30c3\u30c8\u5f62\u5f0f\u306f\u4e0d\u6b63\u3067\u3059");
                ipaddr = "";
                errorFlag = true;
            }
            if (!this.isMask(ipmask)) {
                this.addErrorMessage(conn, "IP\u30de\u30b9\u30af\u304c\u7bc4\u56f2\u5916\u3067\u3059");
                ipmask = "";
                errorFlag = true;
            }
        }
        if (errorFlag) {
            conn.getViewParams().put("ipaddr", ipaddr);
            conn.getViewParams().put("ipmask", ipmask);
            this.forward(true, conn, "/AdminCreateRefusal");
        } else {
            try {
                conn.getRefusal().add(ipaddr, ipmask);
                this.redirectAdmin(conn, "/AdminRefusalList");
                SerializableObject.getInstance().encodeSerializableByRefusalAddress(conn.getRefusal());
            }
            catch (Exception e) {
                e.printStackTrace();
                this.addErrorMessage(conn, "\u7981\u6b62\u30a2\u30c9\u30ec\u30b9\u8a2d\u5b9a\u6642\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f:" + e.getMessage());
                this.forward(true, conn, "/AdminCreateRefusal");
            }
        }
    }

    private boolean isIpAddress(String ipAddr) {
        ArrayList<String> lst = StringUtil.cutString(ipAddr, ".");
        if (lst == null || lst.size() != 4) {
            return false;
        }
        int len = lst.size();
        int i = 0;
        while (i < len) {
            int c = AnalysisUtil.convertInt(lst.get(i));
            if (c < 0 || c > 255) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean isMask(String ipMask) {
        int c = AnalysisUtil.convertInt(ipMask);
        return c > 0 && c <= 32;
    }
}

