/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.conf;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.maachang.proxy.engine.conf.AccessInfo;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.util.Roll;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AccessManager
implements Serializable {
    private static final long serialVersionUID = -1100676817608904943L;
    private static final int MAX_LENGTH = 100;
    private Roll manager = new Roll(100);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(String host, String addr, RequestInfo req, ResponseInfo res) {
        try {
            if (host == null || addr == null || req == null || res == null) {
                return;
            }
            String type = res.getHeader("Content-Type", 0);
            if (type == null) {
                return;
            }
            if (type.indexOf("text/html") <= -1 && type.indexOf("application/xhtml") <= -1 && type.indexOf("text/xml") <= -1 && type.indexOf("text/plain") <= -1) {
                return;
            }
            AccessInfo info = new AccessInfo();
            info.setUrl(String.valueOf(host) + req.getUrl());
            info.setAddr(addr);
            info.setUserAgent(req.getHeader("User-Agent", 0));
            info.setState(res.getState());
            info.setDate(new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").format(new Date()));
            AccessManager accessManager = this;
            synchronized (accessManager) {
                if (!this.manager.add(info)) {
                    this.manager.get();
                    this.manager.add(info);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<AccessInfo> get() {
        ArrayList<AccessInfo> ret = new ArrayList<AccessInfo>();
        AccessManager accessManager = this;
        synchronized (accessManager) {
            int i = 0;
            while (i < 100) {
                AccessInfo info = (AccessInfo)this.manager.reference(i);
                if (info == null) break;
                ret.add(info);
                ++i;
            }
        }
        return ret;
    }
}

