/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.conf;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.util.FileUtil;
import org.maachang.util.NetMask;
import org.maachang.util.StringUtil;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MaachangProxyConfig {
    private static final String CONF_NAME = "conf/maachangProxy.conf";
    private static final String ADMIN_SECTION = "admin";
    private static final String ADMIN_ADDRESS_SECTION = "admin-address";
    private static final String AUTH_MODE = "auth";
    private static final String ADMIN_HOST = "host";
    private static final String AUTH_USER_PASSWD = "user";
    private static final String KEY_NAME = "value";
    private static final String ADMIN_URL_PACKAGE = "org.maachang.proxy.engine.admin.page";
    private static final long CHECK_TIMING = 2500L;
    private String adminHost = null;
    private HashMap<String, String> adminUserPasswd = null;
    private ArrayList<NetMask> adminList = new ArrayList();
    private long fileTime = -1L;
    private long beforeCheckTime = -1L;

    protected void finalize() throws Exception {
        this.adminList = null;
    }

    public synchronized boolean isAdminUrl(String host, String url) throws Exception {
        if (host == null || (host = host.trim()).length() <= 0 || url == null || (url = url.trim()).length() <= 0) {
            return false;
        }
        this.updateCheck();
        if (this.adminHost == null || (this.adminHost = this.adminHost.trim()).length() <= 0) {
            return url.startsWith("/@admin/");
        }
        return this.adminHost.equals(host) && url.startsWith("/@admin/");
    }

    public synchronized boolean isAuthAdmin() throws Exception {
        this.updateCheck();
        return this.adminUserPasswd != null;
    }

    public synchronized boolean isAuth(String user, String passwd) throws Exception {
        this.updateCheck();
        if (this.adminUserPasswd == null) {
            return true;
        }
        if (user == null || (user = user.trim()).length() <= 0) {
            return false;
        }
        String chk = this.adminUserPasswd.get(user);
        if (chk == null || (chk = chk.trim()).length() <= 0) {
            chk = "";
        }
        if (passwd == null || (passwd = passwd.trim()).length() <= 0) {
            passwd = "";
        }
        return chk.equals(passwd);
    }

    public boolean isAdmin(InetAddress addr) throws Exception {
        if (addr == null) {
            return false;
        }
        boolean ret = this.isListMask(this.adminList, addr.getHostAddress());
        if (this.adminList.size() <= 0) {
            return true;
        }
        return ret;
    }

    public boolean isAdmin(String addr) throws Exception {
        if (addr == null || addr.length() <= 0) {
            return false;
        }
        boolean ret = this.isListMask(this.adminList, addr);
        if (this.adminList.size() <= 0) {
            return true;
        }
        return ret;
    }

    public String getAdminUrl(String url) {
        if (!url.startsWith("/@admin/")) {
            return null;
        }
        String ret = url.substring("/@admin/".length());
        int paramPoint = ret.indexOf("?");
        if (paramPoint >= 0) {
            ret = ret.substring(0, paramPoint);
        }
        if ((ret = ret == null || (ret = ret.trim()).length() <= 0 ? "" : StringUtil.changeString(ret, "/", ".")).length() <= 0 || ret.endsWith(".")) {
            if (!ret.endsWith(".")) {
                ret = String.valueOf(ret) + ".";
            }
            ret = String.valueOf(ret) + "AdminLogin";
        }
        if (!ret.startsWith(".")) {
            ret = "." + ret;
        }
        return ADMIN_URL_PACKAGE + ret;
    }

    private synchronized boolean isListMask(ArrayList<NetMask> list, String addr) throws Exception {
        if (addr == null || addr.length() <= 0) {
            return false;
        }
        this.updateCheck();
        int len = list.size();
        int i = 0;
        while (i < len) {
            NetMask mask = list.get(i);
            if (mask.isRange(addr)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private final void updateCheck() throws Exception {
        if (this.beforeCheckTime + 2500L > System.currentTimeMillis()) {
            return;
        }
        this.beforeCheckTime = System.currentTimeMillis();
        long time = FileUtil.getLastTime(CONF_NAME);
        if (time <= 0L) {
            this.fileTime = -1L;
            this.clearData();
        } else if (time != this.fileTime) {
            this.read();
            this.fileTime = time;
        }
    }

    private final void read() throws Exception {
        Config conf = MaachangProxyConfig.getConfig(CONF_NAME);
        this.clearData();
        if (conf == null) {
            return;
        }
        this.readAdmin(conf);
        MaachangProxyConfig.readList(this.adminList, conf, ADMIN_ADDRESS_SECTION);
    }

    private final void clearData() {
        this.adminList.clear();
        this.adminHost = null;
        this.adminUserPasswd = null;
    }

    private void readAdmin(Config conf) throws Exception {
        String[] userList;
        this.adminHost = conf.get(ADMIN_SECTION, ADMIN_HOST, 0);
        this.adminUserPasswd = null;
        if (conf.getBoolean(ADMIN_SECTION, AUTH_MODE, 0) && (userList = conf.getAll(ADMIN_SECTION, AUTH_USER_PASSWD)) != null && userList.length > 0) {
            HashMap<String, String> lst = new HashMap<String, String>();
            int len = userList.length;
            int i = 0;
            while (i < len) {
                String value = userList[i];
                if (value != null && (value = value.trim()).length() > 0) {
                    int p = value.indexOf("|");
                    if (p <= -1) {
                        lst.put(value, "");
                    } else {
                        lst.put(value.substring(0, p).trim(), value.substring(p + 1).trim());
                    }
                }
                ++i;
            }
            if (lst.size() > 0) {
                this.adminUserPasswd = lst;
            }
        }
    }

    private static final void readList(ArrayList<NetMask> list, Config conf, String section) throws Exception {
        String[] values = conf.getAll(section, KEY_NAME);
        if (values == null || values.length <= 0) {
            return;
        }
        int len = values.length;
        int i = 0;
        while (i < len) {
            String value = values[i];
            if (value != null && (value = value.trim()).length() > 0) {
                NetMask mask = new NetMask(value);
                list.add(mask);
            }
            ++i;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static final Config getConfig(String name) {
        BufferedReader r = null;
        try {
            Config ret = new Config();
            r = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));
            ReadIni.analisys(ret, r);
            r.close();
            r = null;
            Config config = ret;
            return config;
        }
        catch (Exception e) {
            Config config = null;
            if (r == null) return config;
            try {
                r.close();
                return config;
            }
            catch (Exception exception) {
                // empty catch block
            }
            return config;
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (Exception exception) {}
            }
        }
    }
}

