/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.conf;

import java.io.Serializable;
import java.net.InetAddress;
import org.maachang.util.NetMask;

public class RefusalAddressManager
implements Serializable {
    private static final long serialVersionUID = 5389336480673506064L;
    private NetMask[] masks = null;

    public synchronized void add(String address, String mask) throws Exception {
        NetMask msk = new NetMask(String.valueOf(address) + "/" + mask);
        if (this.masks == null) {
            this.masks = new NetMask[1];
            this.masks[0] = msk;
        } else {
            NetMask[] tmp = this.masks;
            this.masks = new NetMask[tmp.length + 1];
            System.arraycopy(tmp, 0, this.masks, 0, tmp.length);
            this.masks[tmp.length] = msk;
        }
    }

    public synchronized void remove(int no) {
        if (this.masks == null || no < 0 || no >= this.masks.length) {
            throw new IllegalArgumentException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306e\u7981\u6b62\u30a2\u30af\u30bb\u30b9\u30a2\u30c9\u30ec\u30b9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (this.masks.length == 1) {
            this.masks = null;
        } else {
            int len = this.masks.length;
            NetMask[] tmp = new NetMask[len - 1];
            int cnt = 0;
            int i = 0;
            while (i < len) {
                if (i != no) {
                    tmp[cnt] = this.masks[i];
                    ++cnt;
                }
                ++i;
            }
            this.masks = tmp;
        }
    }

    public synchronized NetMask get(int no) {
        if (this.masks == null || no < 0 || no >= this.masks.length) {
            throw new IllegalArgumentException("\u6307\u5b9a\u9805\u756a[" + no + "]\u306e\u7981\u6b62\u30a2\u30af\u30bb\u30b9\u30a2\u30c9\u30ec\u30b9\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        return this.masks[no];
    }

    public synchronized int size() {
        if (this.masks == null) {
            return 0;
        }
        return this.masks.length;
    }

    public synchronized boolean isRefusal(InetAddress address) {
        if (address == null) {
            return false;
        }
        return this.isRefusal(address.getHostAddress());
    }

    public synchronized boolean isRefusal(String address) {
        if (address == null || (address = address.trim()).length() <= 0) {
            return false;
        }
        if (this.masks == null) {
            return false;
        }
        int len = this.masks.length;
        int i = 0;
        while (i < len) {
            if (this.masks[i].isRange(address)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

