/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.conf;

import org.maachang.proxy.engine.conf.AccessManager;
import org.maachang.proxy.engine.conf.ProxyOptions;
import org.maachang.proxy.engine.conf.RefusalAddressManager;
import org.maachang.proxy.engine.net.server.ProxyManager;
import org.maachang.util.FileUtil;

public class SerializableObject {
    private static final String PROXY_SERIALIZABLE_NAME = "./.prxy";
    private static final String REFUSAL_SERIALIZABLE_NAME = "./.rfsl";
    private static final String ACCESS_SERIALIZABLE_NAME = "./.acc";
    private static final SerializableObject SNGL = new SerializableObject();

    private SerializableObject() {
    }

    public static final SerializableObject getInstance() {
        return SNGL;
    }

    public synchronized void encodeSerializableByProxy(ProxyManager man) throws Exception {
        if (man == null) {
            FileUtil.encodeSerializable(PROXY_SERIALIZABLE_NAME, new ProxyOptions());
        }
        FileUtil.encodeSerializable(PROXY_SERIALIZABLE_NAME, man.convertProxyOptions());
    }

    public synchronized void encodeSerializableByRefusalAddress(RefusalAddressManager conf) throws Exception {
        if (conf == null) {
            FileUtil.encodeSerializable(REFUSAL_SERIALIZABLE_NAME, new RefusalAddressManager());
        }
        FileUtil.encodeSerializable(REFUSAL_SERIALIZABLE_NAME, conf);
    }

    public synchronized void encodeSerializableByAccess(AccessManager man) throws Exception {
        if (man == null) {
            FileUtil.encodeSerializable(ACCESS_SERIALIZABLE_NAME, new AccessManager());
        }
        FileUtil.encodeSerializable(ACCESS_SERIALIZABLE_NAME, man);
    }

    public synchronized ProxyManager decodeSerializeByProxy() throws Exception {
        Object o;
        if (FileUtil.isFileExists(PROXY_SERIALIZABLE_NAME) && (o = FileUtil.decodeSerializable(PROXY_SERIALIZABLE_NAME)) != null && o instanceof ProxyOptions) {
            return new ProxyManager((ProxyOptions)o);
        }
        return new ProxyManager();
    }

    public synchronized RefusalAddressManager decodeSerializeByRefusalAddress() throws Exception {
        Object o;
        if (FileUtil.isFileExists(REFUSAL_SERIALIZABLE_NAME) && (o = FileUtil.decodeSerializable(REFUSAL_SERIALIZABLE_NAME)) != null && o instanceof RefusalAddressManager) {
            return (RefusalAddressManager)o;
        }
        return new RefusalAddressManager();
    }

    public synchronized AccessManager decodeSerializeByAccess() throws Exception {
        Object o;
        if (FileUtil.isFileExists(ACCESS_SERIALIZABLE_NAME) && (o = FileUtil.decodeSerializable(ACCESS_SERIALIZABLE_NAME)) != null && o instanceof AccessManager) {
            return (AccessManager)o;
        }
        return new AccessManager();
    }
}

