/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.conf;

import org.maachang.util.conf.Config;

public class ServerOption {
    private static final int MAX_CONNECT_LENGTH = 999;
    private static final int DEF_CONNECT_LENGTH = 128;
    private static final int MAX_POOL_LENGTH = 250;
    private static final int DEF_POOL_LENGTH = 15;
    private static final int DEF_PORT = 80;
    private static final String SERVER_SECTION = "server";
    private int connectLength = -1;
    private int poolLength = -1;
    private int port = -1;
    private String bindAddress = null;

    private ServerOption() {
    }

    public static final ServerOption create(Config conf) {
        int connectLength = conf.getInt(SERVER_SECTION, "max-connect", 0);
        int poolLength = conf.getInt(SERVER_SECTION, "max-pool", 0);
        int port = conf.getInt(SERVER_SECTION, "server-port", 0);
        String bindAddress = conf.get(SERVER_SECTION, "server-address", 0);
        if (bindAddress == null || (bindAddress = bindAddress.trim()).length() <= 0) {
            bindAddress = null;
        }
        if (connectLength <= -1) {
            connectLength = 128;
        }
        if (connectLength >= 999) {
            connectLength = 999;
        }
        if (poolLength <= -1) {
            poolLength = 15;
        }
        if (poolLength >= 250) {
            poolLength = 250;
        }
        if (port <= -1 || port > 65535) {
            port = 80;
        }
        if (poolLength * 8 >= connectLength) {
            poolLength = connectLength / 8;
        }
        if (poolLength <= 0) {
            poolLength = 1;
        }
        ServerOption ret = new ServerOption();
        ret.connectLength = connectLength;
        ret.poolLength = poolLength;
        ret.port = port;
        ret.bindAddress = bindAddress;
        return ret;
    }

    public String getBindAddress() {
        return this.bindAddress;
    }

    public int getConnectLength() {
        return this.connectLength;
    }

    public int getPoolLength() {
        return this.poolLength;
    }

    public int getPort() {
        return this.port;
    }
}

