/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.error;

import org.maachang.proxy.engine.VersionDef;
import org.maachang.proxy.engine.error.ErrorDef;
import org.maachang.proxy.engine.error.ErrorPageTemplate;
import org.maachang.proxy.engine.mobile.MobileInfo;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.HttpdTimestamp;
import org.maachang.util.FileUtil;
import org.maachang.util.GZIPBinary;
import org.maachang.util.StringUtil;

public class ErrorPageManager {
    private static final String DEFAULT_TEMPLATE = "org/maachang/proxy/engine/error/default.error";
    private static final String ERROR_PAGE = "error.html";
    private static final String ERROR_DIR = "error/";
    private static final String MOBILE_ERROR_HEADER = "m.";
    private String errorPageDir = null;
    private String defaultTemplate = null;
    private static final ErrorPageManager SNGL = new ErrorPageManager();

    private ErrorPageManager() {
    }

    protected void finalize() throws Exception {
        this.errorPageDir = null;
        this.defaultTemplate = null;
    }

    public static final ErrorPageManager getInstance() {
        return SNGL;
    }

    public void create(String directory) throws Exception {
        if (directory == null || (directory = directory.trim()).length() <= 0) {
            throw new IllegalArgumentException("\u30ab\u30ec\u30f3\u30c8\u30c7\u30a3\u30ec\u30af\u30c8\u30ea\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (!(directory = StringUtil.changeString(directory, "\\", "/")).startsWith("/")) {
            directory = "/" + directory;
        }
        if (!directory.endsWith("/")) {
            directory = String.valueOf(directory) + "/";
        }
        this.errorPageDir = String.valueOf(directory) + ERROR_DIR;
        this.defaultTemplate = FileUtil.getScriptByResource(DEFAULT_TEMPLATE, null);
    }

    public void proxyErrorResponse(ResponseInfo res, RequestInfo req, MobileInfo info) throws Exception {
        int state = Integer.parseInt(res.getState());
        if (state < 400) {
            return;
        }
        String template = this.getErrorTemplate(info, res.getState(), req.getUrl());
        if (template == null || template.length() <= 0) {
            return;
        }
        String body = ErrorPageTemplate.createErrorPage(template, String.valueOf(state), ErrorDef.convertErrorMessage(state), null, req.getUrl());
        if (body != null) {
            if (info.getMobileData() != null) {
                res.putHeader("Content-Type", "text/html; charset=SHIFT_JIS");
                res.setBody(body.getBytes("SHIFT_JIS"));
                res.removeHeader("Content-Encoding");
                res.setState("200");
            } else {
                res.putHeader("Content-Type", "text/html; charset=UTF8");
                res.setBody(body.getBytes("UTF8"));
                if (res.getHeader("Content-Encoding", 0) != null && res.getHeader("Content-Encoding", 0).indexOf("zip") >= 0) {
                    res.setBody(GZIPBinary.getInstance().convertBinaryByGZIP(res.getBody()));
                }
            }
            res.putHeader("Content-Length", String.valueOf(res.getBody().length));
        }
    }

    public ResponseInfo getErrorResponse(MobileInfo info, String host, int code, String message, String detail) throws Exception {
        if (message == null || message.length() <= 0) {
            message = ErrorDef.convertErrorMessage(code);
        }
        ResponseInfo ret = new ResponseInfo();
        ret.setState(String.valueOf(code));
        ret.setStateMessage(message);
        ret.setVersion("1.1");
        ret.putHeader("Server", VersionDef.getPrintServerName());
        ret.putHeader("Date", HttpdTimestamp.getNowTimestamp());
        ret.putHeader("Expires", HttpdTimestamp.getTimestamp(0L));
        ret.putHeader("Pragma", "no-cache");
        ret.putHeader("Last-Modified", HttpdTimestamp.getNowTimestamp());
        ret.putHeader("Cache-Control", "private");
        ret.addHeader("Cache-Control", "no-cache");
        ret.addHeader("Cache-Control", "no-store");
        ret.addHeader("Cache-Control", "max-age=0");
        if (info.getMobileData() != null) {
            ret.putHeader("Content-Type", "text/html; charset=SHIFT_JIS");
        } else {
            ret.putHeader("Content-Type", "text/html; charset=UTF8");
        }
        String res = this.getErrorPage(info, host, code, message, detail);
        byte[] body = null;
        if (info.getMobileData() != null) {
            body = res.getBytes("SHIFT_JIS");
            ret.setState("200");
        } else {
            body = res.getBytes("UTF8");
        }
        res = null;
        ret.putHeader("Content-Length", String.valueOf(body.length));
        ret.setBody(body);
        return ret;
    }

    public String getErrorPage(MobileInfo info, String host, int code, String message, String detail) throws Exception {
        String template;
        if (host == null || host.length() <= 0) {
            throw new IllegalArgumentException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (message == null || message.length() <= 0) {
            message = ErrorDef.convertErrorMessage(code);
        }
        if ((template = this.getErrorTemplate(info, String.valueOf(code), host)) == null || template.length() <= 0) {
            template = this.defaultTemplate;
        }
        return ErrorPageTemplate.createErrorPage(template, String.valueOf(code), message, detail, host);
    }

    public String getDefaultErrorPage(String host, int code, String message, String detail) {
        try {
            return ErrorPageTemplate.createErrorPage(this.defaultTemplate, String.valueOf(code), message, detail, host);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getErrorTemplate(MobileInfo info, String state, String url) throws Exception {
        String path = url;
        int p = path.indexOf("/");
        path = p >= 0 ? path.substring(p + 1) : "";
        String codePage = null;
        codePage = info.getMobileData() != null ? MOBILE_ERROR_HEADER + state + ".html" : state + ".html";
        String errorPage = null;
        errorPage = info.getMobileData() != null ? MOBILE_ERROR_HEADER + ERROR_PAGE + ".html" : ERROR_PAGE + ".html";
        while (true) {
            String target;
            if (!(target = this.errorPageDir + path).endsWith("/")) {
                target = String.valueOf(target) + "/";
            }
            if (FileUtil.isFileExists(String.valueOf(target) + codePage)) {
                return FileUtil.getFileByString(String.valueOf(target) + codePage, "UTF8");
            }
            if (FileUtil.isFileExists(String.valueOf(target) + ERROR_PAGE)) {
                return FileUtil.getFileByString(String.valueOf(target) + errorPage, "UTF8");
            }
            if (path.length() <= 0) {
                return null;
            }
            p = path.lastIndexOf("/");
            if (p != -1) {
                if ((p = (path = path.substring(0, p)).lastIndexOf("/")) != -1) {
                    path = path.substring(0, p);
                    continue;
                }
                path = "";
                continue;
            }
            path = "";
        }
    }
}

