/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile;

import org.maachang.proxy.engine.mobile.MobileInfo;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.proxy.engine.mobile.emoji.ConvertEmoji;
import org.maachang.proxy.engine.mobile.emoji.EmojiConfig;
import org.maachang.proxy.engine.mobile.image.ConvertImage;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.CharsetMask;
import org.maachang.util.GZIPBinary;
import org.maachang.util.StringUtil;
import org.maachang.util.ZenToHan;

public class ConvertMobile {
    public static final void convert(ResponseInfo res, MobileInfo info) throws Exception {
        String c;
        RequestInfo req = info.getRequest();
        EmojiConfig conf = info.getEmojiConfig();
        MobileData data = info.getMobileData();
        boolean gzip = false;
        if (data != null) {
            String c2;
            if (res.getHeader("Content-Encoding", 0) != null && (c2 = res.getHeader("Content-Encoding", 0)).indexOf("zip") > 0) {
                byte[] body = GZIPBinary.getInstance().convertGZIPByBinary(res.getBody());
                res.setBody(body);
                res.removeHeader("Content-Encoding");
                gzip = true;
            }
            byte[] body = res.getBody();
            String type = res.getHeader("Content-Type", 0);
            if (type != null && (type.indexOf("text/html") >= 0 || type.indexOf("application/xhtml") >= 0 || type.indexOf("text/xml") >= 0)) {
                String mobCharset;
                String charset = ConvertMobile.getCharset(type);
                boolean isShiftJisFlag = false;
                if ("softbank".equals(data.getCarrier())) {
                    mobCharset = conf.getCharset(conf.getCarrierName(data));
                    if ("Windows-31J".equals(mobCharset)) {
                        mobCharset = "SHIFT_JIS";
                    }
                } else {
                    mobCharset = "SHIFT_JIS";
                    isShiftJisFlag = true;
                }
                if (charset != null) {
                    boolean srcNoChangeCharsetFlag = false;
                    String tmp = null;
                    if (mobCharset.toLowerCase().equals(charset.trim().toLowerCase())) {
                        tmp = new String(body, mobCharset);
                        srcNoChangeCharsetFlag = true;
                    } else {
                        tmp = new String(body, charset);
                        tmp = StringUtil.changeString(tmp, "charset=" + charset, "charset=" + mobCharset);
                    }
                    if (isShiftJisFlag) {
                        tmp = AnalysisUtil.toSJIS(tmp);
                    }
                    tmp = ZenToHan.convertHankaku(tmp);
                    body = tmp.getBytes(mobCharset);
                    res.setBody(body);
                    tmp = null;
                    if (!srcNoChangeCharsetFlag) {
                        int x = type.toLowerCase().indexOf("charset");
                        if (x <= -1) {
                            x = type.indexOf(";");
                            if (x > 0) {
                                type = type.substring(0, x);
                            }
                            type = type + "; charset=" + mobCharset;
                        } else {
                            int xx = type.indexOf(";");
                            type = xx > 0 ? type.substring(0, xx) : type.substring(0, x);
                            type = type + "; charset=" + mobCharset;
                        }
                        res.putHeader("Content-Type", type);
                    }
                }
            }
        } else if (res.getHeader("Content-Encoding", 0) != null && (c = res.getHeader("Content-Encoding", 0)).indexOf("zip") > 0) {
            gzip = true;
            res.setBody(GZIPBinary.getInstance().convertGZIPByBinary(res.getBody()));
        }
        if (!ConvertEmoji.convert(res, conf, data)) {
            ConvertImage.convert(req, res, data);
        }
        if (data == null && gzip) {
            res.setBody(GZIPBinary.getInstance().convertBinaryByGZIP(res.getBody()));
        }
        res.putHeader("Content-Length", String.valueOf(res.getBody().length));
    }

    private static final String getCharset(String type) {
        int p;
        if (type != null && (p = type.indexOf("charset=")) > 0) {
            return CharsetMask.getCharset(type.substring(p + "charset=".length()));
        }
        return null;
    }
}

