/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.carrier;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import org.maachang.proxy.engine.mobile.carrier.MobileConfig;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.util.FileUtil;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

public class CarrierConfig {
    private static final String CARRIER_CONF = "./conf/carrier/carrier.conf";
    private static final String SECTION = "carrier";
    private static final String AGENT_SECTION = "carrier-agent";
    private static final long RELOAD_TIME = 5000L;
    private Config conf = null;
    private HashMap<String, MobileConfig> manager = null;
    private long lastTime = -1L;
    private long beforeTime = -1L;

    private void read() {
        block15: {
            if (this.beforeTime + 5000L <= System.currentTimeMillis()) {
                try {
                    boolean flg = false;
                    if (this.conf == null) {
                        flg = true;
                    } else {
                        long t = FileUtil.getLastTime(CARRIER_CONF);
                        if (t != this.lastTime) {
                            this.lastTime = t;
                            flg = true;
                        }
                    }
                    if (!flg) break block15;
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(CARRIER_CONF), "UTF8"));
                    try {
                        this.conf = new Config();
                        ReadIni.analisys(this.conf, br);
                        br.close();
                        br = null;
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (this.lastTime <= -1L) {
                        this.lastTime = FileUtil.getLastTime(CARRIER_CONF);
                    }
                    this.readSupportCarrier(this.conf);
                    this.beforeTime = System.currentTimeMillis();
                }
                catch (Exception e) {
                    this.conf = null;
                    this.manager = null;
                    this.lastTime = -1L;
                    this.beforeTime = -1L;
                }
            }
        }
    }

    private void readSupportCarrier(Config conf) throws Exception {
        String[] names = conf.getAll(SECTION, "support");
        if (names != null && names.length > 0) {
            int len = names.length;
            this.manager = new HashMap();
            int i = 0;
            while (i < len) {
                MobileConfig mob = new MobileConfig(names[i]);
                this.manager.put(names[i], mob);
                ++i;
            }
        }
    }

    public synchronized String getVersion() {
        this.read();
        if (this.conf == null) {
            return null;
        }
        return this.conf.get(SECTION, "version", 0);
    }

    public synchronized String getVersionDate() {
        this.read();
        if (this.conf == null) {
            return null;
        }
        return this.conf.get(SECTION, "update", 0);
    }

    public synchronized String[] getSupportCarrier() {
        this.read();
        if (this.conf == null) {
            return null;
        }
        return this.conf.getAll(SECTION, "support");
    }

    public synchronized MobileConfig getMobileConfig(String carrier) {
        this.read();
        if (this.conf == null) {
            return null;
        }
        return this.manager.get(carrier);
    }

    public synchronized MobileData getAgent(String userAgent) {
        if (userAgent == null || (userAgent = userAgent.trim()).length() <= 0) {
            return null;
        }
        this.read();
        if (this.conf == null) {
            return null;
        }
        String[] keys = this.conf.getKeys(AGENT_SECTION);
        if (keys != null && keys.length > 0) {
            int len = keys.length;
            int i = 0;
            while (i < len) {
                if (userAgent.indexOf(keys[i]) >= 0) {
                    String carrier = this.conf.get(AGENT_SECTION, keys[i], 0);
                    MobileConfig mob = this.manager.get(carrier);
                    if (mob == null) {
                        return null;
                    }
                    return mob.getMobileData(carrier, userAgent);
                }
                ++i;
            }
        }
        return null;
    }
}

