/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.carrier;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MobileConfig {
    private static final int DOCOMO_USER_AGENT_POS = 11;
    private static final String CONF_DIR = "./conf/carrier/";
    private static final String CONF_PLUS = ".conf";
    private static final long RELOAD_TIME = 5000L;
    private String sectionName = null;
    private long lastTime = -1L;
    private long beforeTime = -1L;
    private HashMap<Integer, ArrayList<MobileData>> datas = null;
    private String sha1 = null;

    private MobileConfig() {
    }

    public MobileConfig(String sectionName) {
        this.sectionName = sectionName;
        this.beforeTime = -1L;
    }

    private void read() {
        block15: {
            if (this.beforeTime + 5000L <= System.currentTimeMillis()) {
                try {
                    String fileName = CONF_DIR + this.sectionName + CONF_PLUS;
                    boolean flg = false;
                    if (this.datas == null) {
                        flg = true;
                    } else {
                        long t = FileUtil.getLastTime(fileName);
                        if (t != this.lastTime) {
                            this.lastTime = t;
                            flg = true;
                        }
                    }
                    if (!flg) break block15;
                    BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(fileName), "UTF8"));
                    Config conf = null;
                    try {
                        conf = new Config();
                        ReadIni.analisys(conf, br);
                        br.close();
                        br = null;
                    }
                    finally {
                        if (br != null) {
                            try {
                                br.close();
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (this.lastTime <= -1L) {
                        this.lastTime = FileUtil.getLastTime(fileName);
                    }
                    this.analysisDatas(conf);
                    this.beforeTime = System.currentTimeMillis();
                }
                catch (Exception e) {
                    this.datas = null;
                    this.sha1 = null;
                    this.lastTime = -1L;
                    this.beforeTime = -1L;
                }
            }
        }
    }

    private void analysisDatas(Config conf) throws Exception {
        this.datas = new HashMap();
        int len = conf.size(this.sectionName, "agent");
        if (len > 0) {
            int i = 0;
            while (i < len) {
                String code = conf.get(this.sectionName, "code", i);
                if (code.indexOf("/") > 0) {
                    ArrayList<String> cds = StringUtil.cutString(code, "/");
                    int lenJ = cds.size();
                    int j = 0;
                    while (j < lenJ) {
                        String target = cds.get(j);
                        String agent = conf.get(this.sectionName, "agent", i);
                        agent = StringUtil.changeString(agent, code, target);
                        agent = this.smartAgentName(this.sectionName, agent);
                        int pos = this.getIndex(this.sectionName, agent);
                        MobileData data = new MobileData();
                        data.setCarrier(this.sectionName);
                        data.setUserAgent(agent);
                        data.setCode(target);
                        data.setType(conf.get(this.sectionName, String.valueOf(code) + ".type", 0));
                        data.setX(conf.getInt(this.sectionName, String.valueOf(code) + ".x", 0));
                        data.setY(conf.getInt(this.sectionName, String.valueOf(code) + ".y", 0));
                        data.setJpegFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".jpg", 0));
                        data.setGifFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".gif", 0));
                        data.setPngFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".png", 0));
                        data.setFlashFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".flash", 0));
                        Integer key = new Integer(pos);
                        ArrayList<MobileData> lst = this.datas.get(key);
                        if (lst == null) {
                            lst = new ArrayList();
                            this.datas.put(key, lst);
                        }
                        lst.add(data);
                        ++j;
                    }
                } else {
                    String agent = conf.get(this.sectionName, "agent", i);
                    agent = this.smartAgentName(this.sectionName, agent);
                    int pos = this.getIndex(this.sectionName, agent);
                    MobileData data = new MobileData();
                    data.setCarrier(this.sectionName);
                    data.setUserAgent(agent);
                    data.setCode(code);
                    data.setType(conf.get(this.sectionName, String.valueOf(code) + ".type", 0));
                    data.setX(conf.getInt(this.sectionName, String.valueOf(code) + ".x", 0));
                    data.setY(conf.getInt(this.sectionName, String.valueOf(code) + ".y", 0));
                    data.setJpegFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".jpg", 0));
                    data.setGifFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".gif", 0));
                    data.setPngFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".png", 0));
                    data.setFlashFlag(conf.getBoolean(this.sectionName, String.valueOf(code) + ".flash", 0));
                    Integer key = new Integer(pos);
                    ArrayList<MobileData> lst = this.datas.get(key);
                    if (lst == null) {
                        lst = new ArrayList();
                        this.datas.put(key, lst);
                    }
                    lst.add(data);
                }
                ++i;
            }
            this.sha1 = conf.get(this.sectionName, "sha1", 0);
        }
    }

    private String smartAgentName(String carrier, String agent) {
        if ("softbank".equals(carrier)) {
            int pos = agent.indexOf("/", 0);
            if (pos <= -1) {
                return agent;
            }
            if ((pos = agent.indexOf("/", pos + 1)) <= -1) {
                return agent;
            }
            if ((pos = agent.indexOf("/", pos + 1)) <= -1) {
                return agent;
            }
            return agent.substring(0, pos);
        }
        int index = 0;
        int p = -1;
        while (true) {
            if ((p = agent.indexOf(" ", index)) <= -1) {
                return agent;
            }
            if (!"docomo".equals(carrier) || p >= 11) break;
            index = p + 1;
        }
        return agent.substring(0, p);
    }

    private int getIndex(String carrier, String userAgent) {
        if ("softbank".equals(carrier)) {
            int pos = userAgent.indexOf("/", 0);
            if (pos <= -1) {
                return userAgent.length();
            }
            if ((pos = userAgent.indexOf("/", pos + 1)) <= -1) {
                return userAgent.length();
            }
            return pos;
        }
        int index = 0;
        int pos = -1;
        pos = userAgent.indexOf(" ", index);
        int pos2 = userAgent.indexOf("/", index);
        if (pos <= -1 || pos2 <= -1) {
            if (pos <= -1) {
                pos = pos2;
            }
        } else if (pos > pos2) {
            pos = pos2;
        }
        if (pos <= -1) {
            pos = userAgent.length();
        }
        return pos;
    }

    public synchronized String getSha1() {
        this.read();
        if (this.datas == null) {
            return null;
        }
        return this.sha1;
    }

    public synchronized MobileData getMobileData(String carrier, String userAgent) {
        if (userAgent == null || (userAgent = userAgent.trim()).length() <= 0) {
            return null;
        }
        this.read();
        if (this.datas == null) {
            return null;
        }
        int pos = this.getIndex(carrier, userAgent);
        ArrayList<MobileData> lst = this.datas.get(new Integer(pos));
        if (lst == null) {
            return null;
        }
        int len = lst.size();
        int i = 0;
        while (i < len) {
            MobileData data = lst.get(i);
            if (userAgent.startsWith(data.getUserAgent())) {
                return data;
            }
            ++i;
        }
        return null;
    }

    public synchronized Object[] getKeys() {
        this.read();
        if (this.datas == null) {
            return null;
        }
        return this.datas.keySet().toArray();
    }

    public synchronized ArrayList<MobileData> getList(Object key) {
        this.read();
        if (this.datas == null) {
            return null;
        }
        return this.datas.get(key);
    }
}

