/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.convert;

import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import org.maachang.util.Digest;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertKeTaiOrgList {
    private static final String OUTPUT_DIR = "conf/carrier/";
    private static final String SERIAL = "/Serial";
    private static final int START_Y = 3;
    private static final int LENGTH_X = 25;
    private static final int[] START_X = new int[]{1, 3, 4, 5, 7, 8};
    private static final int[] START_X2 = new int[]{11, 12, 13, 14};

    public static final void main(String[] args) throws Exception {
        if (args == null || args.length <= 0) {
            return;
        }
        InputStream stream = null;
        try {
            String file = FileUtil.getFullPath(args[1]);
            stream = new FileInputStream(file);
            String outDir = args[0];
            if (!outDir.endsWith("/") && !outDir.endsWith("\\")) {
                outDir = String.valueOf(outDir) + "/";
            }
            outDir = String.valueOf(outDir) + OUTPUT_DIR;
            String simulator = ConvertKeTaiOrgList.getSimulator(args);
            new ConvertKeTaiOrgList().execution(stream, outDir, simulator);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
            stream = null;
        }
    }

    public void execution(InputStream stream, String outDir, String simulator) throws Exception {
        String one;
        BufferedReader reader = new BufferedReader(new InputStreamReader(stream, "Windows-31J"));
        ByteArrayOutputStream docomo = new ByteArrayOutputStream();
        ByteArrayOutputStream au = new ByteArrayOutputStream();
        ByteArrayOutputStream softbank = new ByteArrayOutputStream();
        PrintWriter b1 = new PrintWriter(new OutputStreamWriter((OutputStream)docomo, "UTF8"));
        b1.print("[");
        b1.print("docomo");
        b1.println("]");
        PrintWriter b2 = new PrintWriter(new OutputStreamWriter((OutputStream)au, "UTF8"));
        b2.print("[");
        b2.print("au");
        b2.println("]");
        PrintWriter b3 = new PrintWriter(new OutputStreamWriter((OutputStream)softbank, "UTF8"));
        b3.print("[");
        b3.print("softbank");
        b3.println("]");
        int i = 0;
        while ((one = reader.readLine()) != null) {
            block13: {
                int mobileType;
                PrintWriter p;
                ArrayList<String> lst;
                block15: {
                    String ki;
                    block16: {
                        block14: {
                            if (i < 3 || (lst = StringUtil.cutString(one, ",")) == null || lst.size() < 25) break block13;
                            this.cutCote(lst);
                            ki = lst.get(START_X[0]);
                            if (ki == null || (ki = ki.trim()).length() <= 0) break block13;
                            p = null;
                            ki = ki.toLowerCase();
                            mobileType = 0;
                            if (!"docomo".equals(ki)) break block14;
                            p = b1;
                            mobileType = 1;
                            break block15;
                        }
                        if (!"au".equals(ki)) break block16;
                        p = b2;
                        mobileType = 2;
                        break block15;
                    }
                    if (!"softbank".equals(ki) && !"vodafone".equals(ki)) break block13;
                    p = b3;
                    mobileType = 3;
                }
                String agent = lst.get(START_X[2]);
                String code = lst.get(START_X[1]);
                String type = lst.get(START_X[3]);
                String x = lst.get(START_X[4]);
                String y = lst.get(START_X[5]);
                if (agent != null && (agent = agent.trim()).length() > 0 && (agent = StringUtil.changeString(agent, "\u3000", " ").trim()).length() > 0 && code != null && (code = code.trim()).length() > 0 && x != null && (x = x.trim()).length() > 0 && y != null && (y = y.trim()).length() > 0) {
                    int pp;
                    if (agent.indexOf(SERIAL) != -1 && (agent = agent.substring(0, agent.indexOf(SERIAL))).lastIndexOf("[") != -1) {
                        agent = agent.substring(0, agent.lastIndexOf("["));
                    }
                    boolean gif = false;
                    boolean jpg = false;
                    boolean png = false;
                    boolean flash = false;
                    String tmp = null;
                    tmp = lst.get(START_X2[0]);
                    if (tmp != null && (tmp = tmp.trim()).length() > 0 && "1".equals(tmp)) {
                        gif = true;
                    }
                    if ((tmp = lst.get(START_X2[1])) != null && (tmp = tmp.trim()).length() > 0 && "1".equals(tmp)) {
                        jpg = true;
                    }
                    if ((tmp = lst.get(START_X2[2])) != null && (tmp = tmp.trim()).length() > 0 && "1".equals(tmp)) {
                        png = true;
                    }
                    if ((tmp = lst.get(START_X2[3])) != null && (tmp = tmp.trim()).length() > 0 && "1".equals(tmp)) {
                        flash = true;
                    }
                    if (!(gif || jpg || png)) {
                        jpg = true;
                    }
                    agent = agent.trim();
                    p.print("agent=");
                    p.print("\"");
                    p.print(agent);
                    p.println("\"");
                    p.print("code=");
                    p.print("\"");
                    p.print(code);
                    p.println("\"");
                    p.print(code);
                    p.print(".type=");
                    p.print("\"");
                    p.print(type);
                    p.println("\"");
                    p.print(code);
                    p.print(".x=\"");
                    p.print(x);
                    p.println("\"");
                    p.print(code);
                    p.print(".y=\"");
                    p.print(y);
                    p.println("\"");
                    p.print(code);
                    p.print(".jpg=\"");
                    p.print(jpg);
                    p.println("\"");
                    p.print(code);
                    p.print(".gif=\"");
                    p.print(gif);
                    p.println("\"");
                    p.print(code);
                    p.print(".png=\"");
                    p.print(png);
                    p.println("\"");
                    p.print(code);
                    p.print(".flash=\"");
                    p.print(flash);
                    p.println("\"");
                    if (mobileType == 3 && "on".equals(simulator) && (pp = agent.indexOf("/")) > -1) {
                        agent = agent.startsWith("SoftBank/") ? "Semulator" + agent.substring(pp) : (agent.startsWith("Vodafone/") ? "Vemulator" + agent.substring(pp) : "J-EMULATOR" + agent.substring(pp));
                        code = "SIM@" + code;
                        p.print("agent=");
                        p.print("\"");
                        p.print(agent);
                        p.println("\"");
                        p.print("code=");
                        p.print("\"");
                        p.print(code);
                        p.println("\"");
                        p.print(code);
                        p.print(".type=");
                        p.print("\"");
                        p.print(type);
                        p.println("\"");
                        p.print(code);
                        p.print(".x=\"");
                        p.print(x);
                        p.println("\"");
                        p.print(code);
                        p.print(".y=\"");
                        p.print(y);
                        p.println("\"");
                        p.print(code);
                        p.print(".jpg=\"");
                        p.print(jpg);
                        p.println("\"");
                        p.print(code);
                        p.print(".gif=\"");
                        p.print(gif);
                        p.println("\"");
                        p.print(code);
                        p.print(".png=\"");
                        p.print(png);
                        p.println("\"");
                        p.print(code);
                        p.print(".flash=\"");
                        p.print(flash);
                        p.println("\"");
                    }
                }
            }
            ++i;
        }
        if ("on".equals(simulator)) {
            PrintWriter p = b1;
            String code = "ISIM2.0";
            p.print("agent=");
            p.print("\"");
            p.print("DoCoMo/2.0 ISIM");
            p.println("\"");
            p.print("code=");
            p.print("\"");
            p.print(code);
            p.println("\"");
            p.print(code);
            p.print(".type=");
            p.print("\"");
            p.print("ISIM");
            p.println("\"");
            p.print(code);
            p.print(".x=\"");
            p.print("240");
            p.println("\"");
            p.print(code);
            p.print(".y=\"");
            p.print("270");
            p.println("\"");
            p.print(code);
            p.print(".jpg=\"");
            p.print("true");
            p.println("\"");
            p.print(code);
            p.print(".gif=\"");
            p.print("true");
            p.println("\"");
            p.print(code);
            p.print(".png=\"");
            p.print("false");
            p.println("\"");
            p.print(code);
            p.print(".flash=\"");
            p.print("true");
            p.println("\"");
        }
        b1.flush();
        b2.flush();
        b3.flush();
        String sha1 = null;
        sha1 = Digest.convert("SHA1", docomo.toByteArray());
        b1.println("sha1=\"" + sha1 + "\"");
        sha1 = Digest.convert("SHA1", au.toByteArray());
        b2.println("sha1=\"" + sha1 + "\"");
        sha1 = Digest.convert("SHA1", softbank.toByteArray());
        b3.println("sha1=\"" + sha1 + "\"");
        b1.flush();
        b2.flush();
        b3.flush();
        FileUtil.setFile(String.valueOf(outDir) + "docomo.conf", docomo.toByteArray());
        FileUtil.setFile(String.valueOf(outDir) + "au.conf", au.toByteArray());
        FileUtil.setFile(String.valueOf(outDir) + "softbank.conf", softbank.toByteArray());
        b1.close();
        b2.close();
        b3.close();
        docomo.close();
        au.close();
        softbank.close();
    }

    private void cutCote(ArrayList<String> lst) {
        int len = lst.size();
        int i = 0;
        while (i < len) {
            String one = lst.get(i);
            if (one == null || (one = one.trim()).length() <= 0) {
                lst.set(i, "");
            }
            if ((one = StringUtil.catCote(one)) == null || (one = one.trim()).length() <= 0) {
                lst.set(i, "");
            } else {
                lst.set(i, one);
            }
            ++i;
        }
    }

    private static final String getSimulator(String[] args) {
        if (args.length >= 3) {
            return args[2];
        }
        return null;
    }
}

