/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.convert;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import org.maachang.proxy.engine.mobile.convert.SoftbankValue;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConvertSoftbankPost {
    private static final String SECTION = "softbank-next";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final void main(String[] args) throws Exception {
        String name = args[0];
        String conf = args[1];
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "ISO-8859-1"));
        BufferedReader confReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(conf), "UTF8"));
        Config srcConf = new Config();
        ReadIni.analisys(srcConf, confReader);
        confReader.close();
        confReader = null;
        BufferedOutputStream bo = null;
        HashMap<String, ArrayList<String>> index = ConvertSoftbankPost.index(srcConf);
        ArrayList<SoftbankValue> lst = new ArrayList<SoftbankValue>();
        try {
            String oneLine;
            do {
                if ((oneLine = br.readLine()) != null) continue;
                return;
            } while ((oneLine = oneLine.trim()).length() <= 0);
            String[] s = ConvertSoftbankPost.cutCode(oneLine, "|");
            if (s == null || s.length <= 0) {
                System.out.println("error:\u30c7\u30fc\u30bf\u304c\u5b58\u5728\u3057\u307e\u305b\u3093");
                return;
            }
            int len = s.length;
            System.out.println("len:" + len);
            int cnt = 0;
            int i = 0;
            while (i < len) {
                String v;
                String k = s[i];
                if (k != null && (k = k.trim()).length() > 0 && (v = s[i + 1]) != null && (v = v.trim()).length() > 0) {
                    k = "0x" + k.toUpperCase();
                    v = "0x" + v.toUpperCase();
                    System.out.println("[" + i + "]:" + " k:" + k + " v:" + v);
                    ArrayList<String> x = index.get(k);
                    if (x != null) {
                        int lenJ = x.size();
                        int j = 0;
                        while (j < lenJ) {
                            lst.add(new SoftbankValue(x.get(j), v));
                            ++j;
                        }
                        ++cnt;
                    }
                }
                i += 2;
            }
            System.out.println("cnt:" + cnt);
            if (lst.size() <= 0) {
                System.out.println("error:\u51fa\u529b\u5bfe\u8c61\u306e\u30c7\u30fc\u30bf\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                return;
            }
            Object[] o = lst.toArray();
            Arrays.sort(o);
            len = o.length;
            bo = new BufferedOutputStream(new FileOutputStream(String.valueOf(name) + ".conf"));
            int i2 = 0;
            while (i2 < len) {
                bo.write(((SoftbankValue)o[i2]).toString().getBytes("UTF8"));
                bo.write("\r\n".getBytes("UTF8"));
                ++i2;
            }
            return;
        }
        finally {
            if (bo != null) {
                bo.flush();
                bo.close();
            }
            if (br != null) {
                br.close();
            }
        }
    }

    private static final String[] cutCode(String string, String code) {
        ArrayList<String> lst = new ArrayList<String>();
        int b = 0;
        while (true) {
            int p;
            if ((p = string.indexOf(code, b)) <= -1) break;
            lst.add(string.substring(b, p));
            b = p + code.length();
        }
        lst.add(string.substring(b));
        int len = lst.size();
        String[] ret = new String[len];
        int i = 0;
        while (i < len) {
            ret[i] = (String)lst.get(i);
            ++i;
        }
        return ret;
    }

    private static final HashMap<String, ArrayList<String>> index(Config conf) throws Exception {
        String[] key = conf.getKeys(SECTION);
        if (key == null || key.length <= 0) {
            throw new IOException("softbank\u306e\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        int len = key.length;
        HashMap<String, ArrayList<String>> ret = new HashMap<String, ArrayList<String>>();
        int i = 0;
        while (i < len) {
            String k = key[i];
            if (k.startsWith("e-")) {
                String v = conf.get(SECTION, k, 0);
                System.out.println("@[" + i + "]:" + "k:" + k + " v:" + v);
                if (v != null && v.startsWith("0x")) {
                    ArrayList<Object> ary;
                    if (ret.containsKey(v)) {
                        ary = ret.get(v);
                        ary.add(k);
                    } else {
                        ary = new ArrayList();
                        ret.put(v, ary);
                        ary.add(k);
                    }
                }
            }
            ++i;
        }
        return ret;
    }
}

