/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.emoji;

import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.proxy.engine.mobile.emoji.EmojiConfig;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.StringUtil;

public class ConvertEmoji {
    private static final byte[] START_CD = "[".getBytes();
    private static final byte[] END_CD = "]".getBytes();
    private static final String EMOJI_SIMBOL = "emoji";
    private static final String INPUT_SIMBOL = "input";

    public static final boolean convert(ResponseInfo res, EmojiConfig conf, MobileData data) throws Exception {
        String carrier = conf.getCarrierName(data);
        String type = res.getHeader("Content-Type", 0);
        if (type == null || type.indexOf("text/html") <= -1 && type.indexOf("application/xhtml") <= -1 && type.indexOf("text/xml") <= -1) {
            return false;
        }
        ByteArrayOutputStream bo = new ByteArrayOutputStream();
        int b = 0;
        byte[] body = res.getBody();
        while (true) {
            int p;
            if ((p = AnalysisUtil.binaryIndexOf(body, START_CD, b)) <= -1) {
                if (body.length - b <= 0) break;
                bo.write(body, b, body.length - b);
                break;
            }
            int e = AnalysisUtil.binaryIndexOf(body, END_CD, p);
            if (e <= -1) {
                if (body.length - b <= 0) break;
                bo.write(body, b, body.length - b);
                break;
            }
            int p2 = AnalysisUtil.binaryIndexOf(body, START_CD, p + 1);
            if (p2 != -1 && e > p2) {
                bo.write(body, b, p2 - b);
                b = p2;
                continue;
            }
            bo.write(body, b, p - b);
            byte[] emoji = ConvertEmoji.getEmojiData(conf, data, carrier, body, p, e + 1);
            if (emoji != null) {
                bo.write(emoji);
            }
            b = e + 1;
        }
        body = bo.toByteArray();
        bo = null;
        res.setBody(body);
        return true;
    }

    private static final byte[] getEmojiData(EmojiConfig conf, MobileData data, String carrier, byte[] body, int start, int end) throws Exception {
        if (start + 1 == end) {
            return null;
        }
        int len = end - start;
        byte[] ret = new byte[len];
        System.arraycopy(body, start, ret, 0, len);
        String code = new String(ret, "ISO-8859-1");
        ArrayList<String> lst = StringUtil.cutString(code, "[]: \u3000\r\n\t");
        if (lst == null || lst.size() != 2) {
            return ret;
        }
        String simbol = lst.get(0);
        String value = lst.get(1);
        lst = null;
        if (EMOJI_SIMBOL.equals(simbol.toLowerCase())) {
            byte[] emojiBin = conf.getEmoji(carrier, value);
            if (emojiBin == null) {
                return ret;
            }
            return emojiBin;
        }
        if (data != null && INPUT_SIMBOL.equals(simbol.toLowerCase())) {
            if ("docomo".equals(carrier)) {
                String inKey = "1";
                if ("1".equals(value)) {
                    inKey = "1";
                } else if ("2".equals(value)) {
                    inKey = "2";
                } else if ("3".equals(value)) {
                    inKey = "3";
                } else if ("4".equals(value)) {
                    inKey = "4";
                }
                return ("istyle=\"" + inKey + "\" ").getBytes("ISO-8859-1");
            }
            if ("au".equals(carrier)) {
                String inKey = "*M";
                if ("1".equals(value)) {
                    inKey = "*M";
                } else if ("2".equals(value)) {
                    inKey = "*M";
                } else if ("3".equals(value)) {
                    inKey = "*x";
                } else if ("4".equals(value)) {
                    inKey = "*N";
                }
                return ("format=\"" + inKey + "\" ").getBytes("ISO-8859-1");
            }
            if ("softbank".equals(carrier)) {
                String inKey = "hiragana";
                if ("1".equals(value)) {
                    inKey = "hiragana";
                } else if ("2".equals(value)) {
                    inKey = "hankakukana";
                } else if ("3".equals(value)) {
                    inKey = "alphabet";
                } else if ("4".equals(value)) {
                    inKey = "numeric";
                }
                return ("mode=\"" + inKey + "\" ").getBytes("ISO-8859-1");
            }
            return null;
        }
        return ret;
    }

    public static final void convertRequestBody(RequestInfo req, EmojiConfig conf, MobileData data) throws Exception {
        if (data != null) {
            String carrier = conf.getCarrierName(data);
            conf.convertRequestBody(req, data, carrier);
        }
    }
}

