/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.emoji;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.proxy.engine.mobile.emoji.EmojiEncode;
import org.maachang.proxy.engine.mobile.emoji.EmojiType;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.URLEncode;
import org.maachang.util.conf.Config;
import org.maachang.util.conf.ReadIni;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EmojiConfig {
    private static final String REV_EMOJI_HEAD = "%5Bemoji%3A";
    private static final String REV_EMOJI_FOODER = "%5D";
    private static final String NOT_EMOJI = "\u3013";
    private static final String CONF = "./conf/carrier/emoji.conf";
    private HashMap<String, HashMap<String, byte[]>> manager = null;
    private HashMap<String, ArrayList<String>> reverseHeader = null;
    private HashMap<String, String> reverseFooder = null;
    private HashMap<String, Integer> reverseHeaderDetail = null;
    private HashMap<String, EmojiType> emojiType = null;
    private HashMap<String, HashMap<String, String>> reverse = null;

    public EmojiConfig() throws Exception {
        this.read();
    }

    private void read() throws Exception {
        try {
            Config conf = null;
            BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(CONF), "UTF8"));
            try {
                conf = new Config();
                ReadIni.analisys(conf, br);
                br.close();
                br = null;
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception exception) {}
                }
            }
            this.manager = new HashMap();
            this.reverseHeader = new HashMap();
            this.reverseFooder = new HashMap();
            this.reverseHeaderDetail = new HashMap();
            this.reverse = new HashMap();
            this.emojiType = new HashMap();
            this.analysisConf(conf);
        }
        catch (Exception e) {
            this.manager = null;
            throw e;
        }
    }

    private void analysisConf(Config conf) throws Exception {
        Object[] sections = conf.getSections();
        if (sections != null) {
            int len = sections.length;
            int i = 0;
            while (i < len) {
                String section = (String)sections[i];
                this.manager.put(section, this.analysisSection(conf, section));
                this.setReverseHeader(section, conf);
                this.setReverseFooder(section, conf);
                this.setReverse(section, conf);
                this.setEmojiType(section, conf);
                ++i;
            }
        }
    }

    private HashMap<String, byte[]> analysisSection(Config conf, String section) throws Exception {
        HashMap<String, byte[]> ret = null;
        String headerStr = conf.get(section, "header", 0);
        String fooderStr = conf.get(section, "fooder", 0);
        if (headerStr == null || (headerStr = headerStr.trim()).length() <= 0) {
            headerStr = "";
        }
        if (fooderStr == null || (fooderStr = fooderStr.trim()).length() <= 0) {
            fooderStr = "";
        }
        String baseCharset = conf.get(section, "charset", 0);
        String paramMode = conf.get(section, "param-mode", 0);
        String[] keys = conf.getKeys(section);
        if (keys != null && keys.length > 0) {
            ret = new HashMap<String, byte[]>();
            int len = keys.length;
            int i = 0;
            while (i < len) {
                String key = keys[i];
                if (key != null && (key = key.trim()).length() > 0 && !"header".equals(key) && !"fooder".equals(key)) {
                    byte[] valueBin = null;
                    String value = conf.get(section, key, 0);
                    if (value.startsWith("0x")) {
                        byte[] cb = this.convertBinary(value);
                        if (headerStr.length() > 0 || fooderStr.length() > 0) {
                            byte[] headerBin = null;
                            byte[] fooderBin = null;
                            int binLen = 0;
                            if (headerStr.length() > 0) {
                                headerBin = headerStr.getBytes(baseCharset);
                                binLen += headerBin.length;
                            }
                            if (fooderStr.length() > 0) {
                                fooderBin = fooderStr.getBytes(baseCharset);
                                binLen += fooderBin.length;
                            }
                            valueBin = new byte[binLen += cb.length];
                            int binP = 0;
                            if (headerBin != null) {
                                System.arraycopy(headerBin, 0, valueBin, binP, headerBin.length);
                                binP += headerBin.length;
                            }
                            System.arraycopy(cb, 0, valueBin, binP, cb.length);
                            binP += cb.length;
                            if (fooderBin != null) {
                                System.arraycopy(fooderBin, 0, valueBin, binP, fooderBin.length);
                                binP += fooderBin.length;
                            }
                        } else {
                            valueBin = cb;
                        }
                    } else {
                        valueBin = this.isNumber(value, paramMode) ? (headerStr + value + fooderStr).getBytes(baseCharset) : value.getBytes(baseCharset);
                    }
                    ret.put(key, valueBin);
                }
                ++i;
            }
        }
        return ret;
    }

    private boolean isNumber(String code, String paramMode) {
        if (code == null || code.length() <= 0) {
            return false;
        }
        int len = code.length();
        if ("10".equals(paramMode)) {
            int i = 0;
            while (i < len) {
                char c = code.charAt(i);
                if (c < '0' || c > '9') {
                    return false;
                }
                ++i;
            }
            return true;
        }
        if ("16".equals(paramMode)) {
            int i = 0;
            while (i < len) {
                char c = code.charAt(i);
                if (!(c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F')) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    private byte[] convertBinary(String value) {
        value = value.substring(2);
        int len = value.length() / 2;
        byte[] ret = new byte[len];
        int c = 0;
        int i = 0;
        while (i < len) {
            ret[i] = (byte)(Integer.parseInt(value.substring(c, c + 2), 16) & 0xFF);
            c += 2;
            ++i;
        }
        return ret;
    }

    private byte[] getPcEmoji(String code) throws Exception {
        return ("<img src=\"/@emoji/" + code + "\">").getBytes("UTF8");
    }

    private void setReverseHeader(String section, Config conf) throws Exception {
        int len = conf.size(section, "post-header");
        if (len > 0) {
            ArrayList<String> lst = new ArrayList<String>();
            int i = 0;
            while (i < len) {
                lst.add(conf.get(section, "post-header", i));
                ++i;
            }
            this.reverseHeader.put(section, lst);
        }
        if (conf.size(section, "post-fooder") > 0) {
            int pos = conf.getInt(section, "reverse-header-length", 0);
            int fooder = conf.getInt(section, "reverse-fooder-length", 0);
            int dataLen = conf.getInt(section, "reverse-length", 0) - (pos + fooder) + 2;
            this.reverseHeaderDetail.put(section, new Integer(dataLen));
        } else {
            this.reverseHeaderDetail.put(section, new Integer(conf.get(section, "reverse-length", 0)));
        }
    }

    private void setReverseFooder(String section, Config conf) throws Exception {
        if (conf.size(section, "post-fooder") > 0) {
            this.reverseFooder.put(section, conf.get(section, "post-fooder", 0));
        }
    }

    private void setReverse(String section, Config conf) throws Exception {
        int n = conf.getInt(section, "post-emoji", 0);
        if (n <= -1) {
            return;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (conf.getBoolean(section, "array", 0)) {
            String val;
            String key;
            int pos = conf.getInt(section, "reverse-header-length", 0);
            int fooder = conf.getInt(section, "reverse-fooder-length", 0);
            int dataLen = conf.getInt(section, "reverse-length", 0) - (pos + fooder);
            int i = 1;
            while (i <= 176) {
                key = this.convertReverseKey(i);
                if (key != null && (val = this.convertReverseData(key, n, pos, dataLen, section, conf)) != null) {
                    map.put(val, key.substring(2));
                }
                ++i;
            }
            i = 201;
            while (i <= 276) {
                key = this.convertReverseKey(i);
                if (key != null && (val = this.convertReverseData(key, n, pos, dataLen, section, conf)) != null) {
                    map.put(val, key.substring(2));
                }
                ++i;
            }
        } else {
            String val;
            String key;
            int i = 1;
            while (i <= 176) {
                key = this.convertReverseKey(i);
                if (key != null && (val = this.convertReverseData(key, n, 2, -1, section, conf)) != null) {
                    map.put(val, key.substring(2));
                }
                ++i;
            }
            i = 201;
            while (i <= 276) {
                key = this.convertReverseKey(i);
                if (key != null && (val = this.convertReverseData(key, n, 2, -1, section, conf)) != null) {
                    map.put(val, key.substring(2));
                }
                ++i;
            }
        }
        this.reverse.put(section, map);
    }

    private void setEmojiType(String section, Config conf) {
        this.emojiType.put(section, new EmojiType(conf.get(section, "charset", 0), conf.get(section, "type", 0)));
    }

    private String convertReverseKey(int no) {
        String key = String.valueOf(no);
        return "e-" + "000".substring(key.length()) + key;
    }

    private String convertReverseData(String key, int no, int off, int len, String section, Config conf) throws Exception {
        String val = conf.get(section, key, no);
        if (val == null || (val = val.trim()).length() <= 0) {
            return null;
        }
        if (!val.startsWith("0x")) {
            return null;
        }
        val = val.toLowerCase();
        StringBuilder buf = new StringBuilder();
        len = len <= 0 ? val.length() : (len += off);
        int i = off;
        while (i < len) {
            buf.append("%").append(val.substring(i, i + 2));
            i += 2;
        }
        return buf.toString();
    }

    public String getCharset(String carrier) {
        EmojiType type = this.emojiType.get(carrier);
        if (type == null) {
            return "UTF8";
        }
        return type.getCharset();
    }

    public String getCarrierName(MobileData data) {
        if (data == null) {
            return null;
        }
        String ret = data.getCarrier();
        if (this.isUseType(ret) && !this.isType(ret, data.getType())) {
            ret = String.valueOf(ret) + "-next";
        }
        return ret;
    }

    public boolean isUseType(String carrier) {
        EmojiType t = this.emojiType.get(carrier);
        if (t == null) {
            return false;
        }
        return t.getTypes() != null;
    }

    public boolean isType(String carrier, String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return false;
        }
        EmojiType t = this.emojiType.get(carrier);
        if (t == null) {
            return false;
        }
        return t.isType(type.toLowerCase());
    }

    public byte[] getEmoji(String carrier, String code) throws Exception {
        if (code == null || (code = code.trim()).length() <= 0) {
            return null;
        }
        if (!this.isNumber(code, "10") || code.length() >= 4) {
            return null;
        }
        code = String.valueOf("000".substring(code.length())) + code;
        if (carrier == null || (carrier = carrier.trim()).length() <= 0) {
            return this.getPcEmoji(code);
        }
        HashMap<String, byte[]> ch = this.manager.get(carrier.toLowerCase());
        if (ch == null) {
            return this.getPcEmoji(code);
        }
        return ch.get("e-" + code);
    }

    public void convertRequestBody(RequestInfo request, MobileData mobileData, String carrier) throws Exception {
        String body;
        ArrayList<String> header = this.reverseHeader.get(carrier);
        String fooder = this.reverseFooder.get(carrier);
        if (header == null) {
            return;
        }
        HashMap<String, String> revs = this.reverse.get(carrier);
        int reverseLength = this.reverseHeaderDetail.get(carrier);
        if (request.getBody() != null && request.getBody().length > 0) {
            body = new String(request.getBody(), "ISO-8859-1");
            body = this.convertReverseData(mobileData, carrier, body, header, fooder, revs, reverseLength);
            request.setBody(body.getBytes("ISO-8859-1"));
        }
        if ((body = this.getGetBody(request.getUrl())) != null && body.length() > 0) {
            body = this.convertReverseData(mobileData, carrier, body, header, fooder, revs, reverseLength);
            request.setUrl(AnalysisUtil.cutGetParam(request.getUrl()) + "?" + body);
        }
    }

    private String convertReverseData(MobileData mobileData, String carrier, String body, ArrayList<String> header, String fooder, HashMap<String, String> revs, int reverseLength) throws Exception {
        body = EmojiEncode.convertBodyByCharset(body, this.emojiType.get(carrier).getCharset());
        if (fooder != null) {
            int x;
            int p;
            if (header.size() != 1) {
                return body;
            }
            String head = header.get(0);
            int b = 0;
            while ((p = body.indexOf(head, b)) > -1 && (x = body.indexOf(fooder, p + head.length())) > -1) {
                int dataLen = x - (p + head.length());
                if (dataLen % reverseLength != 0) {
                    b = p + head.length();
                    continue;
                }
                int len = dataLen / reverseLength;
                int ps = p + head.length();
                StringBuilder buf = new StringBuilder();
                int i = 0;
                while (i < len) {
                    String s = body.substring(ps, ps + reverseLength);
                    String val = revs.get(s);
                    if (val != null) {
                        buf.append(REV_EMOJI_HEAD).append(val).append(REV_EMOJI_FOODER);
                    } else {
                        buf.append(URLEncode.convert(NOT_EMOJI, this.emojiType.get(carrier).getCharset()));
                    }
                    ps += reverseLength;
                    ++i;
                }
                String s = buf.toString();
                buf = null;
                body = body.substring(0, p) + s + body.substring(x + fooder.length());
            }
        } else {
            int len = header.size();
            int i = 0;
            while (i < len) {
                int p;
                String hd = header.get(i);
                int b = 0;
                while ((p = body.indexOf(hd, b)) > -1 && p + reverseLength <= body.length()) {
                    String key = body.substring(p, p + reverseLength);
                    String val = revs.get(key);
                    if (val != null) {
                        val = REV_EMOJI_HEAD + val + REV_EMOJI_FOODER;
                        b = p + val.length();
                    } else {
                        val = URLEncode.convert(NOT_EMOJI, this.emojiType.get(carrier).getCharset());
                        b = p + reverseLength;
                    }
                    body = body.substring(0, p) + val + body.substring(p + reverseLength);
                }
                ++i;
            }
        }
        return body;
    }

    private String getGetBody(String url) {
        int p = url.indexOf("?");
        if (p >= 0) {
            return url.substring(p + 1);
        }
        return null;
    }

    public static final void main(String[] args) throws Exception {
        String body = "%f8a3abc%f8a4";
        String carrier = "docomo";
        String type = "mova";
        EmojiConfig emj = new EmojiConfig();
        RequestInfo req = new RequestInfo();
        req.setUrl("/");
        req.setMethod("POST");
        req.setBody(body.getBytes("ISO-8859-1"));
        MobileData m = new MobileData();
        m.setCarrier(carrier);
        m.setType(type);
        emj.convertRequestBody(req, m, emj.getCarrierName(m));
        System.out.println(new String(req.getBody(), "ISO-8859-1"));
    }
}

