/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.emoji;

import java.util.ArrayList;
import java.util.HashSet;
import org.maachang.util.CharsetMask;
import org.maachang.util.StringUtil;

public class EmojiType {
    private String charset = null;
    private HashSet<String> types = null;

    private EmojiType() {
    }

    public EmojiType(String charset, String type) {
        if (type == null || type.length() <= 0) {
            this.types = null;
        } else {
            ArrayList<String> lst = StringUtil.cutString(type, ", \u3000\t");
            int len = lst.size();
            HashSet<String> t = new HashSet<String>();
            int i = 0;
            while (i < len) {
                t.add(lst.get(i).toLowerCase());
                ++i;
            }
            this.types = t;
        }
        this.charset = CharsetMask.getCharset(charset);
    }

    public String getCharset() {
        return this.charset;
    }

    public boolean isType(String type) {
        if (type == null || (type = type.trim()).length() <= 0) {
            return false;
        }
        if (this.types == null) {
            return false;
        }
        return this.types.contains(type.toLowerCase());
    }

    public Object[] getTypes() {
        if (this.types == null) {
            return null;
        }
        return this.types.toArray();
    }
}

