/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.image;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import org.maachang.proxy.engine.mobile.carrier.MobileData;
import org.maachang.proxy.engine.mobile.image.lib.ImageConvertor;
import org.maachang.proxy.engine.mobile.image.lib.ImageInfo;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.ResponseInfo;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.FileUtil;
import org.maachang.util.StringUtil;
import org.maachang.util.conf.ConvIniParam;

public class ConvertImage {
    private static final String CACHE_DIR = "./cache/";
    private static final String PARAM_BASE = "mobile";
    private static final String PERSENT = "persent";
    private static final String RATE = "rate";
    private static final String CACHE_MODE = "cache";
    private static final int WAIT = 100;
    private static final Object sync = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final boolean convert(RequestInfo req, ResponseInfo res, MobileData data) throws Exception {
        if (data == null) {
            return false;
        }
        String type = res.getHeader("Content-Type", 0);
        if (!ConvertImage.isExecution(type)) {
            return false;
        }
        HttpParams params = new HttpParams();
        AnalysisUtil.convertAnalysisQuery(params, req);
        if (!params.isKey(PARAM_BASE)) {
            return false;
        }
        byte[] body = res.getBody();
        if (body == null || body.length <= 0) {
            return false;
        }
        int persent = ConvIniParam.getInt((String)params.get(PERSENT, 0));
        int rate = ConvIniParam.getInt((String)params.get(RATE, 0));
        String cacheMode = (String)params.get(CACHE_MODE, 0);
        String imageType = "JPEG";
        if (data.isJpegFlag()) {
            imageType = "JPEG";
        } else if (data.isPngFlag()) {
            imageType = "PNG";
        } else if (data.isGifFlag()) {
            imageType = "GIF";
        }
        String name = ConvertImage.createCacheName(params, data, imageType, AnalysisUtil.cutGetParam(req.getUrl()), body, persent, rate);
        String file = CACHE_DIR + name;
        boolean useCache = false;
        Object object = sync;
        synchronized (object) {
            useCache = FileUtil.isFileExists(file);
        }
        if (useCache) {
            Object object2;
            while (true) {
                int len = 0;
                object2 = sync;
                synchronized (object2) {
                    len = (int)FileUtil.getLength(file);
                }
                if (len > 1) break;
                Thread.sleep(100L);
            }
            object2 = sync;
            synchronized (object2) {
                useCache = FileUtil.isFileExists(file);
            }
            if (useCache && !ConvertImage.isCache(file, cacheMode)) {
                Object len = sync;
                synchronized (len) {
                    body = FileUtil.getFile(file);
                }
                ConvertImage.setContentType(res, imageType);
                res.setBody(body);
                return true;
            }
        }
        int x = data.getX();
        int y = data.getY();
        if (rate <= 35) {
            rate = 75;
        }
        if (persent <= 25) {
            persent = 100;
        }
        try {
            double r;
            if (cacheMode != null && !cacheMode.startsWith("x") && !cacheMode.startsWith("X")) {
                Object object3 = sync;
                synchronized (object3) {
                    FileUtil.setFile(file, new byte[1]);
                }
            }
            ImageInfo img = ImageConvertor.loadImage(new ByteArrayInputStream(body));
            body = null;
            int w = img.getWidth();
            int h = img.getHeight();
            int cx = x * persent / 100;
            int cy = y * persent / 100;
            if (w >= h) {
                r = (double)h / (double)w;
                w = cx;
                h = (int)((double)cx * r + 0.5);
            } else {
                r = (double)w / (double)h;
                w = (int)((double)cy * r + 0.5);
                h = cy;
            }
            ImageConvertor.convert(img, w, h, -1);
            ByteArrayOutputStream bo = new ByteArrayOutputStream();
            ImageConvertor.saveImage(img, bo, imageType, rate);
            body = bo.toByteArray();
            if (cacheMode != null && !cacheMode.startsWith("x") && !cacheMode.startsWith("X")) {
                Object object4 = sync;
                synchronized (object4) {
                    FileUtil.setFile(file, body);
                }
            }
            ConvertImage.setContentType(res, imageType);
            res.setBody(body);
            return true;
        }
        catch (Exception e) {
            try {
                FileUtil.removeFile(file);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw e;
        }
    }

    private static final boolean isExecution(String type) {
        return type != null && (type.startsWith("image/x-bmp") || type.startsWith("image/gif") || type.startsWith("image/jpeg") || type.startsWith("image/x-png") || type.startsWith("image/tiff"));
    }

    private static final String createCacheName(HttpParams params, MobileData data, String imageType, String url, byte[] body, int persent, int rate) {
        StringBuilder buf = new StringBuilder();
        ArrayList<String> lst = StringUtil.cutString(url, ":/.-");
        int len = lst.size();
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append("_");
            }
            buf.append(lst.get(i));
            ++i;
        }
        buf.append("_").append(imageType.substring(0, 1));
        lst = null;
        if (params.isKey("id")) {
            buf.append("_").append("id-").append(params.get("id", 0));
        }
        buf.append("_").append(Integer.toHexString(body.length)).append("_").append(Integer.toHexString(ConvertImage.getImageCode(body)));
        buf.append("_").append(data.getX()).append("_").append(data.getY());
        buf.append("_");
        if (rate <= -1) {
            buf.append("@0");
        } else {
            buf.append("@");
            buf.append(rate);
        }
        buf.append("_");
        if (persent <= -1) {
            buf.append("0@");
        } else {
            buf.append(persent);
            buf.append("@");
        }
        return buf.toString();
    }

    private static final int getImageCode(byte[] body) {
        int len = body.length;
        return body[len - 1] & 0xFF | (body[len / 2] & 0xFF) << 8 | (body[len / 2 - len / 4] & 0xFF) << 16 | (body[len / 2 + len / 4] & 0xFF) << 24;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final boolean isCache(String file, String cacheMode) {
        if (cacheMode == null || (cacheMode = cacheMode.trim()).length() <= 0) {
            return false;
        }
        long lastTime = 0L;
        Object object = sync;
        synchronized (object) {
            lastTime = FileUtil.getLastTime(file);
        }
        if (cacheMode.startsWith("M")) {
            object = sync;
            synchronized (object) {
                Calendar cl = Calendar.getInstance();
                cl.setTimeInMillis(lastTime);
                cl.add(2, 1);
                lastTime = cl.getTime().getTime();
            }
        } else if (cacheMode.startsWith("d")) {
            lastTime += 86400000L;
        } else if (cacheMode.startsWith("h")) {
            lastTime += 3600000L;
        } else if (cacheMode.startsWith("m")) {
            lastTime += 60000L;
        } else {
            return cacheMode.startsWith("x") || cacheMode.startsWith("X");
        }
        return lastTime <= System.currentTimeMillis();
    }

    private static final void setContentType(ResponseInfo res, String imageType) {
        if ("JPEG".equals(imageType)) {
            res.putHeader("Content-Type", "image/jpeg");
        } else if ("GIF".equals(imageType)) {
            res.putHeader("Content-Type", "image/gif");
        } else if ("PNG".equals(imageType)) {
            res.putHeader("Content-Type", "image/x-png");
        }
    }
}

