/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.image.lib;

import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncodeParam;
import com.sun.media.jai.codec.JPEGEncodeParam;
import com.sun.media.jai.codec.MemoryCacheSeekableStream;
import com.sun.media.jai.codec.PNGEncodeParam;
import com.sun.media.jai.codec.SeekableStream;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.FilteredImageSource;
import java.awt.image.IndexColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.ParameterBlock;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashSet;
import javax.media.jai.JAI;
import javax.media.jai.LookupTableJAI;
import javax.media.jai.ParameterBlockJAI;
import javax.media.jai.PlanarImage;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ColorQuantizerDescriptor;
import javax.media.jai.operator.EncodeDescriptor;
import org.maachang.proxy.engine.mobile.image.lib.GifEncoder;

public class BaseImageConvertor {
    public static final int MAX_COLOR = 255;
    private static final String LOOKUP = "Lookup";
    private static final String ERROR_DIFFUSION = "ErrorDiffusion";
    private static final String DIFFUSION_PARAM = "colorMap";
    private static final String[] FORMAT_JPEG = new String[]{"jpeg", "jpg"};
    private static final String FORMAT_PNG = "png";
    private static final String FORMAT_GIF = "gif";
    private static final double MIN_RATE = 0.0;
    private static final double MAX_RATE = 1.0;

    private BaseImageConvertor() {
    }

    public static final BufferedImage readImage(InputStream stream) throws IOException {
        SeekableStream stm = null;
        RenderedOp op = null;
        BufferedImage ret = null;
        try {
            try {
                stm = BaseImageConvertor.getSeekableStream(stream);
                op = JAI.create((String)"stream", (Object)stm);
                stm.close();
                stm = null;
                ret = BaseImageConvertor.convertJaiToImage(op);
                op = null;
            }
            catch (IOException io) {
                throw io;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            if (stm != null) {
                try {
                    stm.close();
                }
                catch (Exception exception) {}
            }
            stm = null;
            op = null;
        }
        return ret;
    }

    public static final String getImageFormat(InputStream stream) {
        String ret;
        block11: {
            String[] names = null;
            SeekableStream stm = null;
            ret = null;
            try {
                try {
                    stm = BaseImageConvertor.getSeekableStream(stream);
                    names = ImageCodec.getDecoderNames((SeekableStream)stm);
                    stm.close();
                    stm = null;
                    if (names == null || names.length <= 0) {
                        ret = null;
                        break block11;
                    }
                    ret = names[0];
                }
                catch (Exception e) {
                    ret = null;
                }
            }
            finally {
                if (stm != null) {
                    try {
                        stm.close();
                    }
                    catch (Exception exception) {}
                }
                stm = null;
                names = null;
            }
        }
        return ret;
    }

    public static final void writeImage(OutputStream out, BufferedImage image, String format, double rate) throws IOException {
        if (out == null || image == null || format == null || format.length() <= 0) {
            throw new IOException("\u6307\u5b9a\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        format = format.trim().toLowerCase();
        image = BaseImageConvertor.convertTrimImage(image);
        if (FORMAT_JPEG[0].equals(format) || FORMAT_JPEG[1].equals(format)) {
            rate = rate <= 0.0 ? 0.0 : (rate >= 1.0 ? 1.0 : rate);
            BaseImageConvertor.writeJPEG(out, image, rate);
        } else if (FORMAT_PNG.equals(format)) {
            BaseImageConvertor.writePNG(out, image);
        } else if (FORMAT_GIF.equals(format)) {
            BaseImageConvertor.writeGIF(out, image);
        } else {
            throw new IOException("\u6307\u5b9a\u30d5\u30a9\u30fc\u30de\u30c3\u30c8(" + format + ")\u306f\u5bfe\u8c61\u5916\u3067\u3059");
        }
    }

    public static final BufferedImage convertImage(BufferedImage image, int x, int y) {
        Image im = null;
        Graphics gp = null;
        BufferedImage ret = null;
        if (image == null || x <= 0 || y <= 0) {
            return null;
        }
        im = Toolkit.getDefaultToolkit().createImage(new FilteredImageSource(image.getSource(), new AreaAveragingScaleFilter(x, y)));
        ret = new BufferedImage(x, y, 5);
        gp = ret.getGraphics();
        gp.drawImage(im, 0, 0, null);
        gp.dispose();
        im = null;
        gp = null;
        return ret;
    }

    public static final BufferedImage decColorImage(BufferedImage image, int color) throws IOException {
        IndexColorModel im = null;
        BufferedImage ret = null;
        if (image.getColorModel() instanceof IndexColorModel) {
            im = (IndexColorModel)image.getColorModel();
            int ucol = BaseImageConvertor.getUseColor(im);
            if (im.getMapSize() < 32) {
                if (ucol < color) {
                    color = ucol;
                }
                ret = BaseImageConvertor.convertIndex(BaseImageConvertor.convertRGB(image), color);
            } else {
                ret = ucol > color ? BaseImageConvertor.convertIndex(BaseImageConvertor.convertRGB(image), color) : image;
            }
        } else {
            ret = BaseImageConvertor.convertTrimImage(image);
            if (ret.getColorModel().getPixelSize() >= 24) {
                ret = BaseImageConvertor.convertIndex(ret, color);
            }
        }
        return ret;
    }

    private static final void writeJPEG(OutputStream out, BufferedImage image, double rate) throws IOException {
        JPEGEncodeParam jp = null;
        PlanarImage pi = null;
        image = BaseImageConvertor.convertRGB(image);
        jp = new JPEGEncodeParam();
        jp.setQuality((float)rate);
        pi = PlanarImage.wrapRenderedImage((RenderedImage)image);
        JAI.create((String)"encode", (RenderedImage)pi, (Object)out, (Object)FORMAT_JPEG[0], (Object)jp);
        out.flush();
    }

    private static final void writePNG(OutputStream out, BufferedImage image) throws IOException {
        byte[] bin = null;
        int[] plt = null;
        ColorModel cm = null;
        IndexColorModel idx = null;
        ByteArrayOutputStream bo = null;
        PNGEncodeParam.Palette pngPal = null;
        PNGEncodeParam.RGB pngRGB = null;
        try {
            cm = image.getColorModel();
            if (cm instanceof IndexColorModel) {
                idx = (IndexColorModel)cm;
                plt = new int[idx.getMapSize() * 3];
                int len = plt.length;
                int i = 0;
                int j = 0;
                while (i < len) {
                    plt[i] = idx.getRed(j);
                    plt[i + 1] = idx.getGreen(j);
                    plt[i + 2] = idx.getBlue(j);
                    i += 3;
                    ++j;
                }
                idx = null;
                pngPal = (PNGEncodeParam.Palette)PNGEncodeParam.getDefaultEncodeParam((RenderedImage)image);
                pngPal.setPalette(plt);
                plt = null;
                bo = new ByteArrayOutputStream();
                EncodeDescriptor.create((RenderedImage)image, (OutputStream)bo, (String)FORMAT_PNG, (ImageEncodeParam)pngPal, null);
                pngPal = null;
            } else {
                pngRGB = (PNGEncodeParam.RGB)PNGEncodeParam.getDefaultEncodeParam((RenderedImage)image);
                bo = new ByteArrayOutputStream();
                EncodeDescriptor.create((RenderedImage)image, (OutputStream)bo, (String)FORMAT_PNG, (ImageEncodeParam)pngRGB, null);
                pngRGB = null;
            }
            bin = bo.toByteArray();
            bo.close();
            bo = null;
            out.write(bin);
            out.flush();
            bin = null;
        }
        finally {
            if (bo != null) {
                try {
                    bo.close();
                }
                catch (Exception exception) {}
            }
            bin = null;
            plt = null;
            cm = null;
            idx = null;
            bo = null;
            pngPal = null;
            pngRGB = null;
        }
    }

    private static final void writeGIF(OutputStream out, BufferedImage image) throws IOException {
        GifEncoder ge = null;
        try {
            try {
                ge = new GifEncoder(image);
                ge.write(out);
                out.flush();
            }
            catch (IOException io) {
                throw io;
            }
            catch (Exception e) {
                throw new IOException(e.getMessage());
            }
        }
        finally {
            ge = null;
        }
    }

    private static final BufferedImage convertIndex(BufferedImage image, int color) {
        ColorModel cm = null;
        LookupTableJAI lt = null;
        ParameterBlockJAI pb = null;
        RenderedOp pi = null;
        cm = BaseImageConvertor.getDecPalette(image, color);
        lt = BaseImageConvertor.getLookupTable(cm);
        pb = new ParameterBlockJAI(ERROR_DIFFUSION);
        pb.addSource((Object)image);
        pb.setParameter(DIFFUSION_PARAM, (Object)lt);
        pi = JAI.create((String)ERROR_DIFFUSION, (ParameterBlock)pb, null);
        return pi.getAsBufferedImage(pi.getBounds(), cm);
    }

    private static ColorModel getDecPalette(BufferedImage image, int color) {
        byte[] r = null;
        byte[] g = null;
        byte[] b = null;
        byte[][] bin = null;
        ParameterBlockJAI pj = null;
        RenderedOp pi = null;
        LookupTableJAI lt = null;
        pj = new ParameterBlockJAI("ColorQuantizer");
        pj.addSource((Object)image);
        pj.setParameter("quantizationAlgorithm", (Object)ColorQuantizerDescriptor.NEUQUANT);
        pj.setParameter("maxColorNum", color);
        pi = JAI.create((String)"ColorQuantizer", (ParameterBlock)pj, null);
        lt = (LookupTableJAI)pi.getProperty("LUT");
        bin = lt.getByteData();
        int len = lt.getNumEntries();
        int max = BaseImageConvertor.getColor(len);
        r = new byte[max];
        g = new byte[max];
        b = new byte[max];
        int i = 0;
        while (i < len) {
            r[i] = bin[0][i];
            g[i] = bin[1][i];
            b[i] = bin[2][i];
            ++i;
        }
        return new IndexColorModel(BaseImageConvertor.getBits(max), max, r, g, b);
    }

    private static final BufferedImage convertRGB(BufferedImage image) {
        byte[][] dat = null;
        LookupTableJAI lt = null;
        IndexColorModel cm = null;
        BufferedImage ret = null;
        if (image.getColorModel() instanceof IndexColorModel) {
            cm = (IndexColorModel)image.getColorModel();
            int col = cm.getMapSize();
            dat = new byte[3][col];
            cm.getReds(dat[0]);
            cm.getGreens(dat[1]);
            cm.getBlues(dat[2]);
            lt = new LookupTableJAI(dat);
            ret = JAI.create((String)LOOKUP, (RenderedImage)image, (Object)lt).getAsBufferedImage();
        } else {
            ret = image;
        }
        return ret;
    }

    private static final BufferedImage convertTrimImage(BufferedImage image) {
        Graphics2D gp = null;
        BufferedImage ret = null;
        if (image.getColorModel().getPixelSize() >= 32) {
            ret = new BufferedImage(image.getWidth(), image.getHeight(), 5);
            gp = ret.createGraphics();
            gp.drawImage((Image)image, 0, 0, null);
            gp.dispose();
        } else {
            ret = image;
        }
        return ret;
    }

    private static final int getUseColor(IndexColorModel im) {
        HashSet<Integer> hs = null;
        int sz = im.getMapSize();
        hs = new HashSet<Integer>(sz);
        int i = 0;
        while (i < sz) {
            int col = im.getRed(i) << 16 & 0xFF0000 | im.getGreen(i) << 8 & 0xFF00 | im.getBlue(i) & 0xFF;
            hs.add(new Integer(col));
            ++i;
        }
        return hs.size();
    }

    private static final LookupTableJAI getLookupTable(ColorModel model) {
        byte[][] dat = null;
        int color = ((IndexColorModel)model).getMapSize();
        dat = new byte[3][color];
        int i = 0;
        while (i < color) {
            dat[0][i] = (byte)model.getRed(i);
            dat[1][i] = (byte)model.getGreen(i);
            dat[2][i] = (byte)model.getBlue(i);
            ++i;
        }
        return new LookupTableJAI(dat);
    }

    private static int getColor(int col) {
        if (col > 128) {
            return 255;
        }
        if (col > 64) {
            return 128;
        }
        if (col > 32) {
            return 64;
        }
        if (col > 16) {
            return 32;
        }
        if (col > 8) {
            return 16;
        }
        if (col > 4) {
            return 8;
        }
        if (col > 2) {
            return 4;
        }
        if (col == 2) {
            return 2;
        }
        return 1;
    }

    private static int getBits(int col) {
        if (col > 128) {
            return 8;
        }
        if (col > 64) {
            return 7;
        }
        if (col > 32) {
            return 6;
        }
        if (col > 16) {
            return 5;
        }
        if (col > 8) {
            return 4;
        }
        if (col > 4) {
            return 3;
        }
        if (col > 2) {
            return 2;
        }
        return 1;
    }

    private static final BufferedImage convertJaiToImage(RenderedOp in) {
        if (in != null) {
            return in.getAsBufferedImage();
        }
        return null;
    }

    private static final SeekableStream getSeekableStream(InputStream stream) throws Exception {
        Object ret = null;
        ret = stream instanceof SeekableStream ? (SeekableStream)stream : new MemoryCacheSeekableStream(stream);
        return ret;
    }
}

