/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.image.lib;

import java.awt.AWTException;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.PixelGrabber;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class GifEncoder {
    private short imageWidth_;
    private short imageHeight_;
    private int nColors_;
    private byte[] pixels_ = null;
    private byte[] colors_ = null;

    public GifEncoder(Image image) throws AWTException {
        this.imageWidth_ = (short)image.getWidth(null);
        this.imageHeight_ = (short)image.getHeight(null);
        int[] values = new int[this.imageWidth_ * this.imageHeight_];
        PixelGrabber grabber = new PixelGrabber(image, 0, 0, (int)this.imageWidth_, (int)this.imageHeight_, values, 0, (int)this.imageWidth_);
        try {
            if (!grabber.grabPixels()) {
                throw new AWTException("Grabber returned false: " + grabber.status());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[][] r = new byte[this.imageWidth_][this.imageHeight_];
        byte[][] g = new byte[this.imageWidth_][this.imageHeight_];
        byte[][] b = new byte[this.imageWidth_][this.imageHeight_];
        int index = 0;
        int y = 0;
        while (y < this.imageHeight_) {
            int x = 0;
            while (x < this.imageWidth_) {
                r[x][y] = (byte)(values[index] >> 16 & 0xFF);
                g[x][y] = (byte)(values[index] >> 8 & 0xFF);
                b[x][y] = (byte)(values[index] >> 0 & 0xFF);
                ++x;
                ++index;
            }
            ++y;
        }
        this.toIndexColor(r, g, b);
    }

    public GifEncoder(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.imageWidth_ = (short)r.length;
        this.imageHeight_ = (short)r[0].length;
        this.toIndexColor(r, g, b);
    }

    public static void writeFile(Image image, File file) throws AWTException, IOException {
        GifEncoder gifEncoder = new GifEncoder(image);
        gifEncoder.write(new FileOutputStream(file));
    }

    public static void writeFile(Component component, File file) throws AWTException, IOException {
        Image image = component.createImage(component.getWidth(), component.getHeight());
        Graphics graphics = image.getGraphics();
        component.printAll(graphics);
        GifEncoder.writeFile(image, file);
    }

    public void write(OutputStream stream) throws IOException {
        this.writeString(stream, "GIF87a");
        this.writeScreenDescriptor(stream);
        stream.write(this.colors_, 0, this.colors_.length);
        this.writeImageDescriptor(stream, this.imageWidth_, this.imageHeight_, ',');
        byte codeSize = this.bitsNeeded(this.nColors_);
        if (codeSize == 1) {
            codeSize = (byte)(codeSize + 1);
        }
        stream.write(codeSize);
        this.writeLzwCompressed(stream, codeSize, this.pixels_);
        stream.write(0);
        this.writeImageDescriptor(stream, (short)0, (short)0, ';');
        stream.flush();
        stream.close();
    }

    private void toIndexColor(byte[][] r, byte[][] g, byte[][] b) throws AWTException {
        this.pixels_ = new byte[this.imageWidth_ * this.imageHeight_];
        this.colors_ = new byte[768];
        int colornum = 0;
        int x = 0;
        while (x < this.imageWidth_) {
            int y = 0;
            while (y < this.imageHeight_) {
                int search = 0;
                while (search < colornum) {
                    if (this.colors_[search * 3 + 0] == r[x][y] && this.colors_[search * 3 + 1] == g[x][y] && this.colors_[search * 3 + 2] == b[x][y]) break;
                    ++search;
                }
                if (search > 255) {
                    throw new AWTException("Too many colors.");
                }
                this.pixels_[y * this.imageWidth_ + x] = (byte)search;
                if (search == colornum) {
                    this.colors_[search * 3 + 0] = r[x][y];
                    this.colors_[search * 3 + 1] = g[x][y];
                    this.colors_[search * 3 + 2] = b[x][y];
                    ++colornum;
                }
                ++y;
            }
            ++x;
        }
        this.nColors_ = 1 << this.bitsNeeded(colornum);
        byte[] copy = new byte[this.nColors_ * 3];
        System.arraycopy(this.colors_, 0, copy, 0, this.nColors_ * 3);
        this.colors_ = copy;
    }

    private byte bitsNeeded(int n) {
        if (n-- == 0) {
            return 0;
        }
        byte nBitsNeeded = 1;
        while ((n >>= 1) != 0) {
            nBitsNeeded = (byte)(nBitsNeeded + 1);
        }
        return nBitsNeeded;
    }

    private void writeWord(OutputStream stream, short w) throws IOException {
        stream.write(w & 0xFF);
        stream.write(w >> 8 & 0xFF);
    }

    private void writeString(OutputStream stream, String string) throws IOException {
        int i = 0;
        while (i < string.length()) {
            stream.write((byte)string.charAt(i));
            ++i;
        }
    }

    private void writeScreenDescriptor(OutputStream stream) throws IOException {
        this.writeWord(stream, this.imageWidth_);
        this.writeWord(stream, this.imageHeight_);
        int flag = 0;
        byte globalColorTableSize = (byte)(this.bitsNeeded(this.nColors_) - 1);
        flag = (byte)(flag | globalColorTableSize & 7);
        int globalColorTableFlag = 1;
        flag = (byte)(flag | (globalColorTableFlag & 1) << 7);
        int sortFlag = 0;
        flag = (byte)(flag | (sortFlag & 1) << 3);
        int colorResolution = 7;
        flag = (byte)(flag | (colorResolution & 7) << 4);
        int backgroundColorIndex = 0;
        int pixelAspectRatio = 0;
        stream.write(flag);
        stream.write(backgroundColorIndex);
        stream.write(pixelAspectRatio);
    }

    private void writeImageDescriptor(OutputStream stream, short width, short height, char separator) throws IOException {
        stream.write(separator);
        short leftPosition = 0;
        short topPosition = 0;
        this.writeWord(stream, leftPosition);
        this.writeWord(stream, topPosition);
        this.writeWord(stream, width);
        this.writeWord(stream, height);
        int flag = 0;
        int localColorTableSize = 0;
        flag = (byte)(flag | localColorTableSize & 7);
        int reserved = 0;
        flag = (byte)(flag | (reserved & 3) << 3);
        int sortFlag = 0;
        flag = (byte)(flag | (sortFlag & 1) << 5);
        int interlaceFlag = 0;
        flag = (byte)(flag | (interlaceFlag & 1) << 6);
        int localColorTableFlag = 0;
        flag = (byte)(flag | (localColorTableFlag & 1) << 7);
        stream.write(flag);
    }

    private void writeLzwCompressed(OutputStream stream, int codeSize, byte[] toCompress) throws IOException {
        short prefix = -1;
        BitFile bitFile = new BitFile(stream);
        LzwStringTable strings = new LzwStringTable();
        int clearcode = 1 << codeSize;
        int endofinfo = clearcode + 1;
        int numbits = codeSize + 1;
        int limit = (1 << numbits) - 1;
        strings.clearTable(codeSize);
        bitFile.writeBits(clearcode, numbits);
        int loop = 0;
        while (loop < toCompress.length) {
            byte c = toCompress[loop];
            short index = strings.findCharString(prefix, c);
            if (index != -1) {
                prefix = index;
            } else {
                bitFile.writeBits(prefix, numbits);
                if (strings.addCharString(prefix, c) > limit) {
                    if (++numbits > 12) {
                        bitFile.writeBits(clearcode, numbits - 1);
                        strings.clearTable(codeSize);
                        numbits = codeSize + 1;
                    }
                    limit = (1 << numbits) - 1;
                }
                prefix = (short)((short)c & 0xFF);
            }
            ++loop;
        }
        if (prefix != -1) {
            bitFile.writeBits(prefix, numbits);
        }
        bitFile.writeBits(endofinfo, numbits);
        bitFile.flush();
    }

    private class LzwStringTable {
        private static final int RES_CODES = 2;
        private static final short HASH_FREE = -1;
        private static final short NEXT_FIRST = -1;
        private static final int MAXBITS = 12;
        private static final int MAXSTR = 4096;
        private static final short HASHSIZE = 9973;
        private static final short HASHSTEP = 2039;
        private byte[] strChr_ = new byte[4096];
        private short[] strNxt_ = new short[4096];
        private short[] strHsh_ = new short[9973];
        private short nStrings_;

        LzwStringTable() {
        }

        int addCharString(short index, byte b) {
            if (this.nStrings_ >= 4096) {
                return 65535;
            }
            int hshidx = this.hash((short)index, b);
            while (this.strHsh_[hshidx] != -1) {
                hshidx = (hshidx + 2039) % 9973;
            }
            this.strHsh_[hshidx] = this.nStrings_;
            this.strChr_[this.nStrings_] = b;
            this.strNxt_[this.nStrings_] = index != -1 ? index : -1;
            short s = this.nStrings_;
            this.nStrings_ = (short)(s + 1);
            return s;
        }

        short findCharString(short index, byte b) {
            short nxtidx;
            if (index == -1) {
                return b;
            }
            int hshidx = this.hash(index, b);
            while ((nxtidx = this.strHsh_[hshidx]) != -1) {
                if (this.strNxt_[nxtidx] == index && this.strChr_[nxtidx] == b) {
                    return nxtidx;
                }
                hshidx = (hshidx + 2039) % 9973;
            }
            return -1;
        }

        void clearTable(int codesize) {
            this.nStrings_ = 0;
            int q = 0;
            while (q < 9973) {
                this.strHsh_[q] = -1;
                ++q;
            }
            int w = (1 << codesize) + 2;
            int q2 = 0;
            while (q2 < w) {
                this.addCharString((short)-1, (byte)q2);
                ++q2;
            }
        }

        int hash(short index, byte lastbyte) {
            return (((short)(lastbyte << 8) ^ index) & 0xFFFF) % 9973;
        }
    }

    private class BitFile {
        private OutputStream stream_ = null;
        private byte[] buffer_;
        private int streamIndex_;
        private int bitsLeft_;

        BitFile(OutputStream stream) {
            this.stream_ = stream;
            this.buffer_ = new byte[256];
            this.streamIndex_ = 0;
            this.bitsLeft_ = 8;
        }

        void flush() throws IOException {
            int nBytes = this.streamIndex_ + (this.bitsLeft_ == 8 ? 0 : 1);
            if (nBytes > 0) {
                this.stream_.write(nBytes);
                this.stream_.write(this.buffer_, 0, nBytes);
                this.buffer_[0] = 0;
                this.streamIndex_ = 0;
                this.bitsLeft_ = 8;
            }
        }

        void writeBits(int bits, int nBits) throws IOException {
            int nBitsWritten = 0;
            int nBytes = 255;
            do {
                if (this.streamIndex_ == 254 && this.bitsLeft_ == 0 || this.streamIndex_ > 254) {
                    this.stream_.write(nBytes);
                    this.stream_.write(this.buffer_, 0, nBytes);
                    this.buffer_[0] = 0;
                    this.streamIndex_ = 0;
                    this.bitsLeft_ = 8;
                }
                if (nBits <= this.bitsLeft_) {
                    int n = this.streamIndex_;
                    this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << nBits) - 1) << 8 - this.bitsLeft_);
                    nBitsWritten += nBits;
                    this.bitsLeft_ -= nBits;
                    nBits = 0;
                    continue;
                }
                int n = this.streamIndex_++;
                this.buffer_[n] = (byte)(this.buffer_[n] | (bits & (1 << this.bitsLeft_) - 1) << 8 - this.bitsLeft_);
                nBitsWritten += this.bitsLeft_;
                bits >>= this.bitsLeft_;
                nBits -= this.bitsLeft_;
                this.buffer_[this.streamIndex_] = 0;
                this.bitsLeft_ = 8;
            } while (nBits != 0);
        }
    }
}

