/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.mobile.image.lib;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.maachang.proxy.engine.mobile.image.lib.BaseImageConvertor;
import org.maachang.proxy.engine.mobile.image.lib.ImageInfo;

public class ImageConvertor {
    private static final int DEFAULT_RATE = 75;
    private static final int MIN_RATE = 35;
    private static final int MAX_RATE = 100;
    private static final String DEFAULT_TYPE = "JPEG";
    public static final String JPEG_TYPE = "JPEG";
    public static final String GIF_TYPE = "GIF";
    public static final String PNG_TYPE = "PNG";

    private ImageConvertor() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static final ImageInfo loadImage(String name) throws IOException {
        if (name == null) throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        if ((name = name.trim()).length() <= 0) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(name));
        try {
            ImageInfo ret = ImageConvertor.loadImage(stream);
            stream.close();
            stream = null;
            ImageInfo imageInfo = ret;
            return imageInfo;
        }
        catch (IOException io) {
            throw io;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final ImageInfo loadImage(InputStream stream) throws IOException {
        if (stream == null) {
            throw new IOException("\u6307\u5b9a\u30b9\u30c8\u30ea\u30fc\u30e0\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        BufferedImage image = BaseImageConvertor.readImage(stream);
        if (image != null) {
            return new ImageInfo(image);
        }
        throw new IOException("\u30a4\u30e1\u30fc\u30b8\u306e\u30ed\u30fc\u30c9\u306b\u5931\u6557\u3057\u307e\u3057\u305f");
    }

    public static final void saveImage(ImageInfo info, String name, String type, int rate) throws IOException {
        if (info == null || !info.isUse()) {
            throw new IOException("\u30bb\u30fc\u30d6\u5bfe\u8c61\u306e\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (name == null || (name = name.trim()).length() <= 0) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb\u540d\u306f\u4e0d\u6b63\u3067\u3059");
        }
        BufferedOutputStream stream = new BufferedOutputStream(new FileOutputStream(name));
        try {
            ImageConvertor.saveImage(info, stream, type, rate);
            stream.close();
            stream = null;
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static final void saveImage(ImageInfo info, OutputStream stream, String type, int rate) throws IOException {
        if (info == null || !info.isUse()) {
            throw new IOException("\u30bb\u30fc\u30d6\u5bfe\u8c61\u306e\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (stream == null) {
            throw new IOException("\u6307\u5b9a\u30b9\u30c8\u30ea\u30fc\u30e0\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (type == null || (type = type.trim()).length() <= 0) {
            type = "JPEG";
        }
        if (rate == -1) {
            rate = 75;
        } else if (rate <= 35) {
            rate = 35;
        } else if (rate >= 100) {
            rate = 100;
        }
        BufferedImage image = info.getImage();
        if (image == null) {
            throw new IOException("\u30bb\u30fc\u30d6\u5bfe\u8c61\u306e\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        double rateDouble = (double)rate / 100.0;
        BaseImageConvertor.writeImage(stream, image, type, rateDouble);
        stream.flush();
    }

    public static final void convert(ImageInfo info, int width, int height, int color) throws IOException {
        if (info == null || !info.isUse()) {
            throw new IOException("\u30bb\u30fc\u30d6\u5bfe\u8c61\u306e\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        BufferedImage image = info.getImage();
        if (image == null) {
            throw new IOException("\u5bfe\u8c61\u306e\u30a4\u30e1\u30fc\u30b8\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
        }
        if (image.getWidth() != width || image.getHeight() != height) {
            image = BaseImageConvertor.convertImage(image, width, height);
        }
        if (color > 0) {
            image = BaseImageConvertor.decColorImage(image, color);
        }
        info.setImage(image);
    }
}

