/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net;

import java.io.OutputStream;
import java.util.ArrayList;
import org.maachang.proxy.engine.net.ValueInfo;
import org.maachang.util.ArrayBinary;
import org.maachang.util.ConvertParam;

public class RequestInfo {
    private String method = null;
    private String url = null;
    private String version = null;
    private ArrayList<ValueInfo> header = new ArrayList();
    private byte[] body = null;
    private String sessionId = null;
    private String charset = null;
    private static final String CHARSET = "ISO-8859-1";

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        this.method = null;
        this.url = null;
        this.version = null;
        this.header = null;
        this.body = null;
        this.sessionId = null;
        this.charset = null;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getMethod() {
        return this.method;
    }

    public void setUrl(String url) {
        if (url == null || (url = url.trim()).length() <= 0) {
            return;
        }
        if (!url.startsWith("/")) {
            url = "/" + url;
        }
        this.url = url;
    }

    public String getUrl() {
        return this.url;
    }

    public void setVersion(String version) {
        if (version == null || (version = version.trim()).length() <= 0) {
            return;
        }
        if (!(version = version.toUpperCase()).startsWith("HTTP/")) {
            version = "HTTP/" + version;
        }
        this.version = version;
    }

    public String getVersion() {
        if (this.version != null && this.version.startsWith("HTTP/")) {
            return this.version.substring("HTTP/".length());
        }
        return this.version;
    }

    public void setBody(byte[] body) {
        if ("POST".equals(this.method)) {
            this.body = body;
        }
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    public void putHeader(String key, String value) {
        if (this.header == null || key == null || (key = key.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            return;
        }
        ValueInfo info = ValueInfo.getValueInfo(this.header, key);
        if (info == null) {
            info = new ValueInfo();
            info.setKey(key);
            this.header.add(info);
        }
        info.putValue(value);
    }

    public void addHeader(String key, String value) {
        ValueInfo.add(this.header, key, value);
    }

    public void removeHeader(String key) {
        ValueInfo.remove(this.header, key);
    }

    public void removeHeader(String key, int no) {
        ValueInfo.remove(this.header, key, no);
    }

    public String[] getHeader(String key) {
        return ValueInfo.get(this.header, key);
    }

    public String getHeader(String key, int no) {
        return ValueInfo.get(this.header, key, no);
    }

    public int headerSize(String key) {
        return ValueInfo.size(this.header, key);
    }

    public int headerSize() {
        return ValueInfo.size(this.header);
    }

    public byte[] convertHeaderByMaachangCometProxy() throws Exception {
        if (this.method == null || this.url == null || this.version == null || this.header == null || this.header.size() <= 0) {
            return null;
        }
        ArrayBinary ret = new ArrayBinary();
        RequestInfo.putValue(ret, this.method);
        RequestInfo.putValue(ret, this.url);
        RequestInfo.putValue(ret, this.version);
        int len = this.header.size();
        ret.write(ConvertParam.convertInt(len));
        int i = 0;
        while (i < len) {
            ValueInfo val = this.header.get(i);
            if (val != null && val.getKey().length() > 0) {
                int lenJ = val.size();
                RequestInfo.putValue(ret, val.getKey());
                ret.write(ConvertParam.convertInt(lenJ));
                String[] vals = val.getValue();
                int j = 0;
                while (j < lenJ) {
                    RequestInfo.putValue(ret, vals[j]);
                    ++j;
                }
            }
            ++i;
        }
        return ret.getBinary();
    }

    private static final void putValue(ArrayBinary out, String value) throws Exception {
        if (value == null || (value = value.trim()).length() <= 0) {
            out.write(ConvertParam.convertInt(0));
        } else {
            byte[] tmp = value.getBytes(CHARSET);
            out.write(ConvertParam.convertInt(tmp.length));
            out.write(tmp);
        }
    }

    public void outputStream(boolean closeMode, OutputStream out) throws Exception {
        RequestInfo.outputHeader(closeMode, out, this);
        if (this.body != null && this.body.length > 0) {
            out.write(this.body);
        }
        out.flush();
    }

    /*
     * Exception decompiling
     */
    private static final void outputHeader(boolean closeMode, OutputStream out, RequestInfo req) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Statement already marked as first in another block
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.markFirstStatementInBlock(Op03SimpleStatement.java:461)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.Misc.markWholeBlock(Misc.java:251)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.considerAsSimpleIf(ConditionalRewriter.java:673)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op3rewriters.ConditionalRewriter.identifyNonjumpingConditionals(ConditionalRewriter.java:56)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:722)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

