/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net;

import java.util.ArrayList;
import org.maachang.proxy.engine.net.ValueInfo;
import org.maachang.util.ArrayBinary;

public class ResponseInfo {
    private String state = null;
    private String stateMessage = null;
    private String version = null;
    private ArrayList<ValueInfo> header = new ArrayList();
    private byte[] body = null;
    private static final String CHARSET = "ISO-8859-1";
    private static final byte[] ENTER = new byte[]{13, 10};

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.header != null) {
            this.header.clear();
        }
        this.state = null;
        this.stateMessage = null;
        this.version = null;
        this.header = null;
        this.body = null;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public String getStateMessage() {
        return this.stateMessage;
    }

    public void setStateMessage(String stateMessage) {
        this.stateMessage = stateMessage;
    }

    public String getVersion() {
        if (this.version != null && this.version.startsWith("HTTP/")) {
            return this.version.substring("HTTP/".length());
        }
        return this.version;
    }

    public void setVersion(String version) {
        if (version == null || (version = version.trim()).length() <= 0) {
            return;
        }
        if (!(version = version.toUpperCase()).startsWith("HTTP/")) {
            version = "HTTP/" + version;
        }
        this.version = version;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void putHeader(String key, String value) {
        if (this.header == null || key == null || (key = key.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            return;
        }
        ValueInfo info = ValueInfo.getValueInfo(this.header, key);
        if (info == null) {
            info = new ValueInfo();
            info.setKey(key);
            this.header.add(info);
        }
        info.putValue(value);
    }

    public void putHeader(String key, String[] value) {
        if (this.header == null || key == null || (key = key.trim()).length() <= 0 || value == null || value.length <= 0) {
            return;
        }
        ValueInfo info = ValueInfo.getValueInfo(this.header, key);
        if (info == null) {
            info = new ValueInfo();
            info.setKey(key);
            this.header.add(info);
        }
        info.putValue(value);
    }

    public void addHeader(String key, String value) {
        ValueInfo.add(this.header, key, value);
    }

    public void removeHeader(String key) {
        ValueInfo.remove(this.header, key);
    }

    public void removeHeader(String key, int no) {
        ValueInfo.remove(this.header, key, no);
    }

    public String[] getHeader(String key) {
        return ValueInfo.get(this.header, key);
    }

    public String getHeader(String key, int no) {
        return ValueInfo.get(this.header, key, no);
    }

    public int headerSize(String key) {
        return ValueInfo.size(this.header, key);
    }

    public int headerSize() {
        return ValueInfo.size(this.header);
    }

    public String getBodyCharset() {
        int p;
        String s = ValueInfo.get(this.header, "Content-Type", 0);
        if (s != null && (p = s.indexOf("charset=")) > 0) {
            return s.substring(p + "charset=".length());
        }
        return null;
    }

    public byte[] responseByBinary() throws Exception {
        return this.responseByBinary(true);
    }

    public byte[] responseByBinary(boolean mode) throws Exception {
        if (this.state == null || this.version == null || this.header == null) {
            return null;
        }
        ArrayBinary ret = new ArrayBinary();
        ret.write((this.version + " " + this.state).getBytes(CHARSET));
        if (this.stateMessage != null && this.stateMessage.length() > 0) {
            ret.write((" " + this.stateMessage).getBytes(CHARSET));
        }
        ret.write(ENTER);
        int len = this.header.size();
        int i = 0;
        while (i < len) {
            ValueInfo info = this.header.get(i);
            int lenJ = info.size();
            if (lenJ > 0) {
                StringBuilder buf = new StringBuilder();
                buf.append(info.getKey()).append(": ");
                int j = 0;
                while (j < lenJ) {
                    if (j != 0) {
                        buf.append(", ");
                    }
                    buf.append(info.getValue(j));
                    ++j;
                }
                buf.append("\r\n");
                ret.write(buf.toString().getBytes(CHARSET));
                buf = null;
            }
            ++i;
        }
        ret.write(ENTER);
        if (mode && this.body != null && this.body.length > 0) {
            ret.write(this.body);
            ret.write(ENTER);
        }
        return ret.getBinary();
    }

    public String toString() {
        if (this.header == null) {
            return "";
        }
        StringBuilder buf = new StringBuilder();
        buf.append(" state:").append(this.state).append("\n").append(" stateMessage:").append(this.stateMessage).append("\n").append(" version:").append(this.version).append("\n").append(" header:").append(this.header).append("\n");
        if (this.body != null) {
            buf.append(" bodyLength:").append(this.body.length);
        }
        return buf.toString();
    }
}

