/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net;

import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ValueInfo {
    private String key = null;
    private String[] value = null;

    public void setKey(String key) {
        this.key = key;
    }

    public String getKey() {
        return this.key;
    }

    public void putValue(String[] value) {
        this.value = value;
    }

    public void putValue(String value) {
        if (value == null || (value = value.trim()).length() <= 0) {
            return;
        }
        this.value = new String[1];
        this.value[0] = value;
    }

    public void addValue(String value) {
        if (value == null || (value = value.trim()).length() <= 0) {
            return;
        }
        if (this.value != null) {
            int len = this.value.length;
            String[] t = new String[len + 1];
            System.arraycopy(this.value, 0, t, 0, len);
            t[len] = value;
            this.value = t;
        } else {
            this.value = new String[1];
            this.value[0] = value;
        }
    }

    public void removeValue(int no) {
        if (no < 0 || this.value == null || this.value.length <= no) {
            return;
        }
        int len = this.value.length;
        if (len == 1) {
            this.value = null;
            return;
        }
        String[] t = new String[len - 1];
        int cnt = 0;
        int i = 0;
        while (i < len) {
            if (i != no) {
                t[cnt] = this.value[i];
                ++cnt;
            }
            ++i;
        }
        this.value = t;
    }

    public String[] getValue() {
        return this.value;
    }

    public String getValue(int no) {
        if (no < 0 || this.value == null || this.value.length <= no) {
            return null;
        }
        return this.value[no];
    }

    public int size() {
        if (this.value == null) {
            return 0;
        }
        return this.value.length;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("\n\t").append(" key:").append(this.key);
        buf.append(" value(");
        int len = 0;
        if (this.value != null) {
            len = this.value.length;
        }
        buf.append(len).append("):{");
        int i = 0;
        while (i < len) {
            if (i != 0) {
                buf.append(",");
            }
            buf.append(this.value[i]);
            ++i;
        }
        buf.append("}");
        return buf.toString();
    }

    protected static void add(ArrayList<ValueInfo> lst, String key, String value) {
        if (lst == null || key == null || (key = key.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            return;
        }
        ValueInfo info = ValueInfo.getValueInfo(lst, key);
        if (info == null) {
            info = new ValueInfo();
            info.setKey(key);
            lst.add(info);
        }
        info.addValue(value);
    }

    protected static void remove(ArrayList<ValueInfo> lst, String key) {
        if (lst == null) {
            return;
        }
        int no = ValueInfo.search(lst, key);
        if (no <= -1) {
            return;
        }
        lst.remove(no);
    }

    protected static void remove(ArrayList<ValueInfo> lst, String key, int no) {
        if (lst == null || no < 0) {
            return;
        }
        int res = ValueInfo.search(lst, key);
        if (res <= -1) {
            return;
        }
        ValueInfo info = lst.get(res);
        if (info == null) {
            return;
        }
        if (info.size() <= 1) {
            lst.remove(no);
        } else {
            info.removeValue(no);
        }
    }

    protected static String[] get(ArrayList<ValueInfo> lst, String key) {
        if (lst == null) {
            return null;
        }
        ValueInfo info = ValueInfo.getValueInfo(lst, key);
        if (info == null) {
            return null;
        }
        return info.getValue();
    }

    protected static String get(ArrayList<ValueInfo> lst, String key, int no) {
        if (lst == null || no < 0) {
            return null;
        }
        ValueInfo info = ValueInfo.getValueInfo(lst, key);
        if (info == null) {
            return null;
        }
        return info.getValue(no);
    }

    protected static int size(ArrayList<ValueInfo> lst, String key) {
        if (lst == null) {
            return 0;
        }
        ValueInfo info = ValueInfo.getValueInfo(lst, key);
        if (info == null) {
            return 0;
        }
        return info.size();
    }

    protected static int size(ArrayList<ValueInfo> lst) {
        if (lst == null) {
            return 0;
        }
        return lst.size();
    }

    protected static final int search(ArrayList<ValueInfo> lst, String key) {
        if (lst == null || lst.size() <= 0 || key == null || (key = key.trim()).length() <= 0) {
            return -1;
        }
        int len = lst.size();
        int i = 0;
        while (i < len) {
            String k = lst.get(i).getKey();
            if (key.hashCode() == k.hashCode() && key.equals(k)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected static final ValueInfo getValueInfo(ArrayList<ValueInfo> lst, String key) {
        int no = ValueInfo.search(lst, key);
        if (no <= -1) {
            return null;
        }
        return lst.get(no);
    }
}

