/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.util.ArrayList;
import java.util.HashMap;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.http.HttpParams;
import org.maachang.proxy.engine.net.http.HttpdTimestamp;
import org.maachang.proxy.engine.net.server.ProxyInfo;
import org.maachang.util.AnalysisUtil;
import org.maachang.util.StringUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cookie {
    public static final String GET_COOKIE = "Cookie";
    public static final String SET_COOKIE = "Set-Cookie";
    public static final String SESSION_NAME = "maachang-session";
    public static final String SESSION_PARAM = "_maachang-session";
    public static final byte[] SESSION_PARAM_BIN = "_maachang-session".getBytes();

    public static final String createCookie(String key, String value, String path) throws Exception {
        return Cookie.createCookie(key, value, path, Long.MIN_VALUE);
    }

    public static final String createCookie(String key, String value, String path, long expire) throws Exception {
        if (key == null || (key = key.trim()).length() <= 0 || value == null || (value = value.trim()).length() <= 0) {
            throw new IllegalArgumentException("key\u53ca\u3073value\u306f\u5fc5\u9808\u6761\u4ef6\u3067\u3059");
        }
        if (key.indexOf("=") != -1) {
            throw new IllegalArgumentException("key\u540d[" + key + "]\u306b\u306f\u4e0d\u6b63\u306a\u6587\u5b57\u304c\u683c\u7d0d\u3055\u308c\u3066\u3044\u307e\u3059");
        }
        StringBuilder buf = new StringBuilder();
        buf.append(key).append("=").append(value).append(";");
        if (path != null && (path = path.trim()).length() > 0) {
            buf.append(" path=").append(path).append(";");
        }
        if (expire != Long.MIN_VALUE) {
            buf.append(" expires=").append(HttpdTimestamp.getTimestamp(true, expire)).append(";");
        }
        return buf.toString();
    }

    public static final HashMap<String, String> analysisCookie(String cookie) throws Exception {
        if (cookie == null || (cookie = cookie.trim()).length() <= 0) {
            throw new IllegalArgumentException("Cookie\u60c5\u5831\u306f\u4e0d\u6b63\u3067\u3059");
        }
        ArrayList<String> lst = StringUtil.cutString(true, false, cookie, ":; =");
        if (lst == null || lst.size() <= 0) {
            return null;
        }
        HashMap<String, String> ret = new HashMap<String, String>();
        int len = lst.size();
        int i = 0;
        while (i < len) {
            String key = lst.get(i).trim();
            String value = lst.get(i + 1);
            ret.put(key, value);
            i += 2;
        }
        return ret;
    }

    public static final String getSessionId(ProxyInfo info, RequestInfo request) throws Exception {
        HttpParams params = null;
        HashMap<String, String> ana = null;
        String sessionKey = info.getSessionName();
        String id = null;
        String cookie = request.getHeader(GET_COOKIE, 0);
        if (cookie != null) {
            if (ana == null) {
                ana = Cookie.analysisCookie(cookie);
            }
            if ((id = sessionKey == null || sessionKey.length() <= 0 ? ana.get(SESSION_NAME) : ana.get(sessionKey)) != null) {
                request.setSessionId(id);
                return id;
            }
        }
        if (id == null) {
            byte[] body;
            if (request.getUrl().indexOf("?") > 0) {
                if (params == null) {
                    params = AnalysisUtil.convertAnalysisQuery(request);
                }
                if ((id = sessionKey == null || sessionKey.length() <= 0 ? (String)params.get(SESSION_PARAM) : (String)params.get(sessionKey)) != null) {
                    request.setSessionId(id);
                    return id;
                }
            }
            if ((body = request.getBody()) != null) {
                int bodyLen = body.length;
                byte[] sessionKeyBin = null;
                sessionKeyBin = sessionKey == null || sessionKey.length() <= 0 ? SESSION_PARAM_BIN : sessionKey.getBytes("ISO-8859-1");
                int p = AnalysisUtil.binaryIndexOf(body, sessionKeyBin, 0, bodyLen);
                if (p > -1) {
                    int r = AnalysisUtil.binaryIndexOf(body, "&", p, bodyLen);
                    if (r <= -1) {
                        r = bodyLen;
                    }
                    bodyLen = r - (p + sessionKeyBin.length + 1);
                    byte[] idBin = new byte[bodyLen];
                    System.arraycopy(body, p + sessionKeyBin.length + 1, idBin, 0, bodyLen);
                    id = new String(idBin, "ISO-8859-1");
                    idBin = null;
                    if (id != null) {
                        request.setSessionId(id);
                        return id;
                    }
                }
            }
        }
        return null;
    }
}

