/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.util.Vector;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.http.HttpSocket;

class KeepAliveTimeoutThread
extends Thread {
    private Vector<ConnectionInfo> manager = null;
    private volatile boolean stopFlag = false;
    private final Object sync = new Object();
    private static final long WAIT_TIME = 500L;

    public KeepAliveTimeoutThread() {
        this.manager = new Vector();
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
        if (this.manager != null) {
            this.manager.clear();
        }
        this.manager = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(ConnectionInfo conn) {
        if (conn == null || !conn.isUse()) {
            return;
        }
        Object object = this.sync;
        synchronized (object) {
            this.manager.add(conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ConnectionInfo conn) {
        if (conn == null || !conn.isUse()) {
            return;
        }
        int len = this.manager.size();
        Object object = this.sync;
        synchronized (object) {
            int i = 0;
            while (i < len) {
                if (this.manager.get(i) == conn) {
                    this.manager.set(i, null);
                }
                ++i;
            }
        }
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        ThreadDeath threadDeach = null;
        boolean endFlag = false;
        block9: while (true) {
            try {
                Thread.sleep(500L);
                if (endFlag || this.isStop() || this.manager == null) {
                    endFlag = true;
                    break;
                }
                int len = 0;
                len = this.manager.size();
                if (len <= 0) continue;
                int i = len - 1;
                while (true) {
                    if (i < 0) continue block9;
                    ConnectionInfo conn = null;
                    Object object = this.sync;
                    synchronized (object) {
                        conn = this.manager.get(i);
                    }
                    if (conn == null || !conn.isUse()) {
                        this.manager.remove(i);
                    } else if (conn.getTimer() + conn.getTimeout() <= System.currentTimeMillis()) {
                        HttpSocket socket = conn.getSocket();
                        socket.destroy();
                        this.manager.remove(i);
                    }
                    --i;
                }
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
            catch (NullPointerException ie) {
            }
            catch (OutOfMemoryError ie) {
            }
            catch (Exception ie) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

