/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.http.KeepAliveTimeoutThread;

class KeepAliveTimerManager {
    private static final long MIN_TIMEOUT = 1000L;
    private static final long MAX_TIMEOUT = 120000L;
    private static final long DEF_TIMEOUT = 3000L;
    private static final int MIN_KEEP_ALIVE_COUNT = 5;
    private static final int MAX_KEEP_ALIVE_COUNT = 999;
    private static final int DEF_KEEP_ALIVE_COUNT = 100;
    private long timeout = -1L;
    private int keepAliveCount = -1;
    private KeepAliveTimeoutThread timeoutThread = null;

    public KeepAliveTimerManager() {
        this(3000L);
    }

    public KeepAliveTimerManager(long timeout) {
        this(timeout, 100);
    }

    public KeepAliveTimerManager(long timeout, int keepAliveCount) {
        if (timeout <= 1000L) {
            timeout = 1000L;
        } else if (timeout >= 120000L) {
            timeout = 120000L;
        }
        if (keepAliveCount <= 5) {
            keepAliveCount = 5;
        } else if (keepAliveCount >= 999) {
            keepAliveCount = 999;
        }
        this.timeout = timeout;
        this.keepAliveCount = keepAliveCount;
        this.timeoutThread = new KeepAliveTimeoutThread();
    }

    public void append(ConnectionInfo conn) {
        this.timeoutThread.append(conn);
    }

    public void remove(ConnectionInfo conn) {
        this.timeoutThread.remove(conn);
    }

    public long getTimeout() {
        return this.timeout;
    }

    public int getKeepAliveCount() {
        return this.keepAliveCount;
    }
}

