/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import org.maachang.proxy.engine.net.http.HttpServer;
import org.maachang.proxy.engine.net.http.HttpSocket;
import org.maachang.proxy.engine.net.http.NetSocketManager;

class NetAcceptThread
extends Thread {
    private HttpServer server = null;
    private NetSocketManager manager = null;
    private volatile boolean stopFlag = true;

    private NetAcceptThread() {
    }

    public NetAcceptThread(HttpServer server, NetSocketManager manager) throws Exception {
        this.server = server;
        this.manager = manager;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public NetSocketManager getVtSocketManager() {
        return this.manager;
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            HttpSocket s = null;
            try {
                s = this.server.accept();
                if (s == null) continue;
                this.manager.append(s);
            }
            catch (InterruptedException ite) {
                endFlag = true;
            }
            catch (NullPointerException ite) {
            }
            catch (OutOfMemoryError ite) {
            }
            catch (Exception ite) {
            }
            catch (ThreadDeath td) {
                endFlag = true;
                threadDeach = td;
            }
        }
        this.server = null;
        this.manager = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

