/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.io.BufferedInputStream;
import java.nio.channels.CancelledKeyException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.proxy.engine.net.RequestInfo;
import org.maachang.proxy.engine.net.http.CloseClientException;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.http.HttpCallbackReceive;
import org.maachang.proxy.engine.net.http.HttpSocket;
import org.maachang.proxy.engine.net.http.NetInputStream;
import org.maachang.proxy.engine.net.http.NetUseQueue;
import org.maachang.proxy.engine.net.http.ReadHttpdRequest;
import org.maachang.util.SequenceSync;

class NetPoolThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(NetPoolThread.class);
    private NetUseQueue queue = null;
    private HttpCallbackReceive receive = null;
    private SequenceSync sequence = null;
    private volatile boolean stopFlag = true;
    private static final long WAIT_TIME = 30L;

    private NetPoolThread() {
    }

    public NetPoolThread(NetUseQueue queue, HttpCallbackReceive receive, SequenceSync sequence) throws Exception {
        this.queue = queue;
        this.receive = receive;
        this.sequence = sequence;
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        ThreadDeath threadDeach = null;
        boolean errorFlag = false;
        boolean endFlag = false;
        while (true) {
            errorFlag = false;
            HttpSocket conn = null;
            try {
                try {
                    if (endFlag || this.isStop()) break;
                    conn = this.queue.getQueue();
                    if (conn != null) {
                        ConnectionInfo info = conn.getConnectionInfo();
                        if (info == null || !info.isUse()) continue;
                        int seqId = this.sequence.getId();
                        if (LOG.isInfoEnabled()) {
                            LOG.info((Object)("receive(" + seqId + ") - [" + info.getSocket().socket().getInetAddress().getHostAddress() + ":" + info.getSocket().socket().getPort() + "]"));
                        }
                        if (LOG.isDebugEnabled()) {
                            long tm = System.currentTimeMillis();
                            this.receive.execution(info, seqId, NetPoolThread.readHttpdRequest(conn, seqId));
                            LOG.debug((Object)("## receiveTime(" + seqId + ") - " + (System.currentTimeMillis() - tm) + "ms."));
                        } else {
                            this.receive.execution(info, seqId, NetPoolThread.readHttpdRequest(conn, seqId));
                        }
                        if (conn.isCloseFlag()) {
                            conn.destroy();
                            continue;
                        }
                        boolean isCloseFlag = false;
                        try {
                            if (!info.isUse()) {
                                isCloseFlag = true;
                            }
                        }
                        catch (Exception ex) {
                            isCloseFlag = true;
                        }
                        if (!isCloseFlag) {
                            info.update();
                            if (info.getCount() > 0) {
                                if (info.getTimeout() > 0L) {
                                    info.recyclingConnection();
                                }
                            } else {
                                isCloseFlag = true;
                            }
                        }
                        if (!isCloseFlag) continue;
                        conn.destroy();
                        continue;
                    }
                    NetPoolThread.sleep(30L);
                }
                finally {
                    if (!errorFlag || conn == null) continue;
                    conn.destroy();
                }
            }
            catch (CloseClientException ce) {
                errorFlag = true;
            }
            catch (InterruptedException ie) {
                errorFlag = true;
                endFlag = true;
            }
            catch (CancelledKeyException ck) {
                errorFlag = true;
                LOG.warn((Object)"## cancell - key");
            }
            catch (OutOfMemoryError mem) {
                errorFlag = true;
                LOG.error((Object)"## out-of-memory-error", (Throwable)mem);
            }
            catch (Exception e) {
                errorFlag = true;
                LOG.error((Object)"## error", (Throwable)e);
            }
            catch (ThreadDeath td) {
                errorFlag = true;
                endFlag = true;
                threadDeach = td;
            }
        }
        this.queue = null;
        this.receive = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }

    private static final RequestInfo readHttpdRequest(HttpSocket socket, int seqId) throws Exception {
        if (socket == null || socket.isClosed()) {
            return null;
        }
        BufferedInputStream buf = null;
        try {
            buf = new BufferedInputStream(new NetInputStream(socket.inputStream()));
            RequestInfo ret = ReadHttpdRequest.receiveHttpRequest(buf, seqId);
            buf.close();
            buf = null;
            socket.update();
            RequestInfo requestInfo = ret;
            return requestInfo;
        }
        finally {
            if (buf != null) {
                try {
                    buf.close();
                }
                catch (Exception exception) {}
                buf = null;
            }
        }
    }
}

