/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.proxy.engine.net.http.ConnectionInfo;
import org.maachang.proxy.engine.net.http.HttpSocket;
import org.maachang.proxy.engine.net.http.KeepAliveTimerManager;
import org.maachang.proxy.engine.net.http.NetSocketManager;
import org.maachang.proxy.engine.net.http.NetUseQueue;

class NetReceiveThread
extends Thread {
    private static final Log LOG = LogFactory.getLog(NetReceiveThread.class);
    private KeepAliveTimerManager timeMan = null;
    private NetSocketManager manager = null;
    private NetUseQueue queue = null;
    private volatile boolean stopFlag = true;

    private NetReceiveThread() {
    }

    public NetReceiveThread(KeepAliveTimerManager timerManager, NetSocketManager manager) throws Exception {
        this.timeMan = timerManager;
        this.manager = manager;
        this.queue = new NetUseQueue();
        this.stopFlag = false;
        this.setDaemon(true);
        this.start();
    }

    public void destroy() {
        this.setStop(true);
    }

    public NetUseQueue getUseQueue() {
        return this.queue;
    }

    public synchronized boolean isStop() {
        return this.stopFlag;
    }

    private synchronized void setStop(boolean mode) {
        this.stopFlag = mode;
    }

    public void run() {
        boolean endFlag = false;
        ThreadDeath threadDeach = null;
        while (!endFlag && !this.isStop()) {
            try {
                int len = this.manager.size();
                if (len > 0) {
                    int i = len - 1;
                    while (i >= 0) {
                        HttpSocket s = null;
                        try {
                            s = this.manager.get(i);
                            if (s.isClosed()) {
                                this.manager.remove(i);
                            } else if (s.isReceive()) {
                                this.manager.remove(i);
                                ConnectionInfo conn = null;
                                conn = s.getConnectionInfo();
                                if (conn == null) {
                                    conn = new ConnectionInfo(s, this.manager, this.timeMan);
                                    s.setConnectionInfo(conn);
                                } else {
                                    this.timeMan.remove(conn);
                                }
                                this.queue.append(s);
                            }
                        }
                        catch (IOException io) {
                            if (s != null) {
                                s.destroy();
                            }
                            this.manager.remove(i);
                        }
                        catch (InterruptedException ite) {
                            endFlag = true;
                        }
                        catch (NullPointerException ite) {
                        }
                        catch (OutOfMemoryError mem) {
                            LOG.error((Object)"## out-of-memory-error", (Throwable)mem);
                        }
                        catch (Exception e) {
                            LOG.error((Object)"## error", (Throwable)e);
                        }
                        catch (ThreadDeath td) {
                            endFlag = true;
                            threadDeach = td;
                        }
                        --i;
                    }
                }
                Thread.sleep(5L);
            }
            catch (InterruptedException ie) {
                endFlag = true;
            }
        }
        this.manager = null;
        this.queue = null;
        this.setStop(true);
        if (threadDeach != null) {
            throw threadDeach;
        }
    }
}

