/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import org.maachang.proxy.engine.net.http.HttpServer;
import org.maachang.proxy.engine.net.http.HttpSocket;

class NetServerImpl
implements HttpServer {
    private static final int TIMEOUT = 500;
    private static final int DEFAULT_PORT = 3333;
    protected static final int MIN_LENGTH = 1;
    protected static final int MAX_LENGTH = 5000;
    private ServerSocket serverSocket = null;

    private NetServerImpl() {
    }

    public NetServerImpl(int port, int backlog) throws Exception {
        this(null, port, backlog);
    }

    public NetServerImpl(InetAddress addr, int port, int backlog) throws Exception {
        if (backlog <= 1) {
            backlog = 1;
        } else if (backlog > 5000) {
            backlog = 5000;
        }
        if (port <= 0 || port > 65535) {
            port = 3333;
        }
        ServerSocket server = new ServerSocket();
        server.setReuseAddress(true);
        server.setSoTimeout(500);
        if (addr == null) {
            server.bind(new InetSocketAddress(port), backlog);
        } else {
            server.bind(new InetSocketAddress(addr, port), backlog);
        }
        this.serverSocket = server;
    }

    protected void finalize() throws Exception {
        this.destroy();
    }

    public void destroy() {
        if (this.serverSocket != null) {
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.serverSocket = null;
    }

    public HttpSocket accept() throws Exception {
        if (this.isClosed()) {
            throw new IOException("\u30b5\u30fc\u30d0\u30bd\u30b1\u30c3\u30c8\u306f\u5229\u7528\u51fa\u6765\u307e\u305b\u3093");
        }
        HttpSocket ret = null;
        try {
            Socket s = this.serverSocket.accept();
            ret = new HttpSocket(s);
        }
        catch (SocketTimeoutException st) {
            ret = null;
        }
        catch (Exception e) {
            throw e;
        }
        return ret;
    }

    public ServerSocket serverSocket() {
        if (this.isClosed()) {
            return null;
        }
        return this.serverSocket;
    }

    public boolean isClosed() {
        boolean ret = false;
        try {
            if (this.serverSocket == null || !this.serverSocket.isBound() || this.serverSocket.isClosed()) {
                ret = true;
            }
        }
        catch (Exception e) {
            ret = true;
        }
        return ret;
    }
}

