/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.proxy.engine.net.http;

import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.maachang.proxy.engine.conf.SslOption;
import org.maachang.proxy.engine.net.http.HttpCallbackReceive;
import org.maachang.proxy.engine.net.http.KeepAliveTimerManager;
import org.maachang.proxy.engine.net.http.NetAcceptThread;
import org.maachang.proxy.engine.net.http.NetPoolThread;
import org.maachang.proxy.engine.net.http.NetReceiveThread;
import org.maachang.proxy.engine.net.http.NetServerImpl;
import org.maachang.proxy.engine.net.http.NetSocketManager;
import org.maachang.proxy.engine.net.http.NetSslServerImpl;
import org.maachang.proxy.engine.net.http.SslServerFactory;
import org.maachang.util.SequenceSync;

public class NetService {
    private static final Log LOG = LogFactory.getLog(NetService.class);
    private SslServerFactory sslFactory = null;
    private NetAcceptThread accept = null;
    private NetAcceptThread sslAccept = null;
    private NetReceiveThread server = null;
    private NetPoolThread[] pool = null;
    private SequenceSync sequence = null;

    protected void finalize() throws Exception {
        this.close();
    }

    public void open(HttpCallbackReceive executionObject, SslOption opt, int maxConnect, int length, int port) throws Exception {
        this.open(executionObject, opt, maxConnect, length, null, port);
    }

    public void open(HttpCallbackReceive executionObject, SslOption opt, int maxConnect, int length, InetAddress addr, int port) throws Exception {
        if (executionObject == null) {
            throw new IllegalArgumentException("\u5bfe\u8c61\u6761\u4ef6\u306f\u4e0d\u6b63\u3067\u3059");
        }
        this.close();
        try {
            int sslCon = -1;
            if (opt != null) {
                sslCon = maxConnect / 4;
                if (sslCon <= 0) {
                    sslCon = 1;
                }
                maxConnect -= sslCon;
            }
            NetServerImpl server = new NetServerImpl(addr, port, maxConnect);
            NetSocketManager manager = new NetSocketManager();
            this.accept = new NetAcceptThread(server, manager);
            if (sslCon > 0) {
                this.sslFactory = new SslServerFactory(opt);
                NetSslServerImpl sslServer = new NetSslServerImpl(this.sslFactory, opt.getSslAddress(), opt.getSslPort(), sslCon);
                this.sslAccept = new NetAcceptThread(sslServer, manager);
            } else {
                this.sslFactory = null;
                this.sslAccept = null;
            }
            this.sequence = new SequenceSync();
            KeepAliveTimerManager timerMan = new KeepAliveTimerManager();
            this.server = new NetReceiveThread(timerMan, manager);
            this.pool = new NetPoolThread[length];
            int i = 0;
            while (i < length) {
                this.pool[i] = new NetPoolThread(this.server.getUseQueue(), executionObject, this.sequence);
                ++i;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"## error", (Throwable)e);
            this.close();
            throw e;
        }
    }

    public void close() {
        if (this.accept != null) {
            this.accept.destroy();
        }
        if (this.sslAccept != null) {
            this.sslAccept.destroy();
        }
        if (this.server != null) {
            this.server.destroy();
        }
        if (this.pool != null) {
            int len = this.pool.length;
            int i = 0;
            while (i < len) {
                if (this.pool[i] != null) {
                    this.pool[i].destroy();
                }
                this.pool[i] = null;
                ++i;
            }
        }
        this.accept = null;
        this.server = null;
        this.pool = null;
        this.sslFactory = null;
    }

    public SslServerFactory getSslServerFactory() {
        return this.sslFactory;
    }
}

